
function fit_funct_st_jr,p

common calibrate,i_obs,wave

;  define calibration states and corresponding orientation of optics

; cal_optics - LSO
   ; 7
   ; CLEAR
   ; LIN POL    0 deg, LIN POL  90 deg, LIN POL  45 deg, LIN POL 135 deg,
   ; LIN POL   0  deg + RETARDER  45 deg, LIN POL   0 deg + RETARDER 135 deg
;       clear
;            lin 0
;                lin 90
;                      lin 45
;                             lin 135
;                                  lin0+ret45
;                                         lin0+ret135
; variables from ST
pol=    [0,  1,   1,   1,     1,    1,     1 ] ;  pol determines whether polarizer is present
p_angle=[0., 0., 90., 45., 135.,    0.,    0.]
ret=    [0,  0,   0,   0,     0,    1,     1 ] ;  ret determines whether retarder is present
r_angle=[0., 0.,  0.,  0.,    0.,  45.,  135.]

; renaming variables from p input variable
ptrans=p(0)  ;  1 - transmission of calibration polarizer 
rtrans=p(1)  ;  1 - transmission of calibration retarder  
delta =p(2)  ;  1 - retardation  of calibration retarder   
input =p(3:6);  4 - input Stokes vector                   
omx=[[1.,p(7:9)],[1.,p(10:12)],[1.,p(13:15)],[1.,p(16:18)]] ; 16(4x4) - O matrix

; linear polarizar degree of polarization = TOTAL
pp=1.0 ; part. polarization = 1.0

; output = Omatrix ## MMmatrix ## input calculation
obs=fltarr(4,7)

for i=0,6 do begin

  if pol[i] eq 0 and ret[i] eq 0 then begin ; clear
     obs[*,i] = omx ## input     
  endif

  if pol[i] eq 1 and ret[i] eq 0 then begin ; polarizer only
     ;                 mueller_partial_polarizer(transmission, part. polarization, orient. angle)
     obs[*,i] = omx ## mueller_partial_polarizer(ptrans,pp,p_angle[i]) ## input
  endif
  
  if pol(i) eq 1 and ret(i) eq 1 then begin ; retarder and polarizer
     ;                 mueller_retarder(transmission, retardation (deg), orient. angle (degrees))
     obs[*,i] = 1.08 * omx  ## mueller_retarder(rtrans,r_angle[i],delta) ## $                
     ;                 mueller_partial_polarizer(transmission, part. polarization, orient. angle)
                       mueller_partial_polarizer(ptrans,pp,p_angle[i])   ## input
  endif

endfor

return,obs
end
