function comps_fit_for_omx

;  procedure to fit for the o matrix given the observed intensities for the four modulation states
;  for the seven calibration states

common calibrate,i_obs,wave

debug='yes'
ans=' '


;  quantities to be fit are (total of 19):

;  transmission of calibration polarizer (1)
;  transmission of calibration retarder (1)
;  retardation of calibration retarder (1)
;  input Stokes vector (4)
;  O matrix (12) elements with exception of first element of each row

;  observables are (total of 28)::

;  measured intensity with no calibration optics
;  measured intensity calibration polarizer at 0, 90, 45, and 135 deg
;  measured intensity with cal polarizer at 0 deg followed by cal retarder at +45 and -45 deg
;  at each of four modulation states


;  use powell minimization to find unknowns

nparam=19		;number of parameters to fit
nobs=7		;number of observed states


;  create initial guess

guess=dblarr(nparam,/nozero)
guess[0]=0.5          ;50% cal polarizer transmission
guess[1]=1.0          ;100% cal retarder transmission
guess[2]=360.*.25*750./wave       ;retardance
mean_i=mean(i_obs[*,0])
guess[3:6]=[mean_i,0.,0.,0.]    ;unpolarized input Stokes vector with mean intensity from clear

guess[7:9]=[(i_obs[0,1]-i_obs[0,2])/2.,(i_obs[0,3]-i_obs[0,4])/2.,(i_obs[0,5]-i_obs[0,6])/2.]/mean_i
guess[10:12]=[(i_obs[1,1]-i_obs[1,2])/2.,(i_obs[1,3]-i_obs[1,4])/2.,(i_obs[1,5]-i_obs[1,6])/2.]/mean_i
guess[13:15]=[(i_obs[2,1]-i_obs[2,2])/2.,(i_obs[2,3]-i_obs[2,4])/2.,(i_obs[2,5]-i_obs[2,6])/2.]/mean_i
guess[16:18]=[(i_obs[3,1]-i_obs[3,2])/2.,(i_obs[3,3]-i_obs[3,4])/2.,(i_obs[3,5]-i_obs[3,6])/2.]/mean_i

a=guess
xi=dblarr(nparam,nparam) & for i=0,nparam-1 do xi(i,i)=1.d0
powell,a,xi,1.d-8,fmin,'min_funct',iter=iter,itmax=50000,/double

print,'fmin:',fmin,'  iter:',iter

return,a
end