function fit_funct,p

common calibrate,i_obs,wave

;  define calibration states and corresponding orientation of optics

pol=    [0,  1,  1,  1,  1,  1,  1]		;  pol determines whether polarizer is present
ret=    [0,  0,  0,  0,  0,  1,  1]		;  ret determines whether retarder is present
p_angle=[0.,0.,90.,45.,135.,  0.,  0.]
r_angle=[0., 0., 0.,  0.,  0., 45.,-45.]

ptrans=p(0)
rtrans=p(1)
delta=p(2)
input=p(3:6)
omx=[[1.,p(7:9)],[1.,p(10:12)],[1.,p(13:15)],[1.,p(16:18)]]

pp=1.0
obs=fltarr(4,7)
for i=0,6 do begin

	if pol[i] eq 0 and ret[i] eq 0 then begin 	;clear
     obs[*,i]=omx##input

  endif else if pol[i] eq 1 and ret[i] eq 0 then begin  	;polarizer only
    obs[*,i]=omx##mueller_partial_polarizer(ptrans,pp,p_angle[i])##input

  endif else if pol(i) eq 1 and ret(i) eq 1 then begin  	;retarder and polarizer
    obs[*,i]=1.08*omx##mueller_retarder(rtrans,r_angle[i],delta)## $
    mueller_partial_polarizer(ptrans,pp,p_angle[i])##input
  endif

endfor

return,obs
end