;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

PRO start_idl

!X.STYLE=1
!Y.STYLE=1
!Z.STYLE=1

!x.thick=2 & !y.thick=2
!p.thick=2

!P.TICKLEN=1./30.

!P.FONT=0

device,retain=2
Device, Decomposed=0

return
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

PRO start_headline

  print
  print,' ONDREJOV RADIO B FITS FILES VISUALIZATION'
  print

return
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

PRO path_ondrejov_radio_B_FTS_files, path_data
  
cd,current=path_0
path_data=strmid(path_0,0,strpos(path_0,'/',/reverse_search))
path_data=strmid(path_data,0,strpos(path_0,'/',/reverse_search))
path_data=path_data+'/data/'
path_data=dialog_pickfile(path=path_data,filter='*.FTS', $
                          TITLE='Choose directory with BYYMMDD.FTS files')

return
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

PRO read_ondrejov_radio_B_FTS_file, filenames, n_fts_files, $
                                    data,time_ss,time_hh,frequencies, $
                                    t1,t2,nt,dt,f1,f2,df,nf,$
                                    date,time1,time2,t1_fod,t2_fod,n_min,$
                                    hh1,mm1,ss1,hh2,mm2,ss2,$
                                    station
  
for f=0,n_fts_files-1 do begin

   fits_read,filenames(f),d,h
   
   if f eq 0 then begin
      date=sxpar(h,'DATE') ; DD.MM.YY
      date=strmid(date,6,4)+strmid(date,3,2)+strmid(date,0,2) ; YYYYMMDD
      nt_one=sxpar(h,'XMAX')-sxpar(h,'XMIN')+1
      nt=nt_one*(n_fts_files) & nf=sxpar(h,'YMAX')-sxpar(h,'YMIN')+1
      data=intarr(nt,nf)
   endif
   if f eq 0 then begin      
      data(nt_one*f:nt_one*(f+1)-1,*)=rebin($
                       d(sxpar(h,'XMIN'):sxpar(h,'XMAX'),$
                       sxpar(h,'YMIN'):sxpar(h,'YMAX')),$
                       nt_one/1.,sxpar(h,'YMAX')-sxpar(h,'YMIN')+1)
      shift_x0=0
      tmp1=sxpar(h,'TIME1')
      time1=tmp1
      hh1=fix(strmid(tmp1,0,2))
      mm1=fix(strmid(tmp1,3,2))
      ss1=fix(strmid(tmp1,6,2))
      t1=hhmmss_fod(hh1,mm1,ss1)*24. ; [HH.HH]
      tmp1=sxpar(h,'RATE') & tmp2=sxpar(h,'INTEG')
      dt=float(1./tmp1)*float(tmp2) ;[ps]
   endif else begin
      data(nt_one*(f)+shift_x0:nt_one*(f+1)+shift_x0-1,*)=$
          d(sxpar(h,'XMIN'):sxpar(h,'XMAX'),sxpar(h,'YMIN'):sxpar(h,'YMAX'))
   endelse
      if f ne 0 then data(nt_one*(f+1-1)+shift_x0-1,*)=data(nt_one*(f+1-1)+shift_x0-1-1,*)
      
endfor

tmp2=sxpar(h,'TIME2')
time2=tmp2
hh2=fix(strmid(tmp2,0,2))
mm2=fix(strmid(tmp2,3,2))
ss2=fix(strmid(tmp2,6,2))

; final parameters
nt=n_elements(data(*,0))
t1_fod=fltarr(1) & t2_fod=fltarr(1)
t1_fod(0)=(float(hh1)+float(mm1)/60.+float(ss1)/3600.)/24.
time_ss=findgen(nt)*dt ; [s]
; corr - an estension for good time axis
t2_fod(0)=(float(hh2)+float(mm2)/60.+float(ss2)/3600.+3./3600.)/24. 
t2=(hhmmss_fod(hh2,mm2,ss2)+3.*dt/3600.)*24.
time_ss(nt-1)=time_ss(nt-1)+3.*dt
; final parameters
time_hh=time_ss/3600.+t1 ; UT      

; number of minutes
n_min=round((t2_fod-t1_fod)*60.)

;frequencies [MHz] 
frequencies=fltarr(nf) 
f2=sxpar(h,'FMAX') & f1=sxpar(h,'FMIN')
df=(f2-f1)/float(nf-1) 
for f=0,nf-1 do begin
   frequencies(f)=f2-f*df
endfor

station='ONDREJOV'

return
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

PRO font_adjustment_via_tmp_file_output_to_eps

key_plot=4 ; eps 
; output file open
pathfilename_out='fig_tmp_due_to_font'
window_plot_save_start_jr,key_plot,window_index=0,$
       window_title='RADIOSPECTROGRAM',$
       window_size=[1000*1.1,540]*1.25,pathfilename_out=pathfilename_out
plot,findgen(100),title='x'
; output close
window_plot_save_end_jr, key_plot, pathfilename_out=pathfilename_out
; removal
spawn,'rm fig_tmp_due_to_font.eps'

return
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

PRO eps_output_start, key_plot,window_width,aspect_ratio,$
                      path_plots,pathfilename_out_core,$
                      date,time1,time2,f1,f2,lut

pathfilename_out_core=''
print
; finemaout 1st part: date,time,fre,lut
pathfilename_out_start=date+'_'+time1+'-'+time2+'_'+$
                       strtrim(round(f1),2)+'-'+strtrim(round(f2),2)+'_'+$
                       'lut_'+strtrim(lut,2)
print,' INFO : output filename beginning = '+pathfilename_out_start
pathfilename_out_add=''
read,pathfilename_out_add,prompt=' INPUT: EPS/JPEG filename addition = '
if pathfilename_out_add ne '' then begin
   under_tmp='_'
endif else begin
   under_tmp=''
endelse   
pathfilename_out_core=pathfilename_out_start+under_tmp+pathfilename_out_add
window_plot_save_start_jr,key_plot,window_index=0,$
                          window_size=window_width*[1.,aspect_ratio]*1.5,$
                          pathfilename_out=path_plots+pathfilename_out_core

return
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

PRO eps_output_end, key_plot,path_plots,pathfilename_out_core

window_plot_save_end_jr, key_plot,pathfilename_out=path_plots+pathfilename_out_core

key_plot=0

return
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

PRO eps_to_jpeg, path_plots,pathfilename_out_core
  
; eps -> jpg
print,' JPEG output of the plot/image...'
spawn,'convert -density 600x600 '+path_plots+pathfilename_out_core+'.eps'+' '$
                                 +path_plots+pathfilename_out_core+'.jpg'

return
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

; ONDREJOV radio B FITS files visualization

; JR, 2020/01/16, v.4

; start_idl
start_idl

; start parameters
key=0

; start_headline
start_headline

; monitor size
device,get_SCREEN_SIZE=monitor_size

; directory selection
path_ondrejov_radio_B_FTS_files, path_data

; FTS file list
fts_file_list=file_search(path_data,'*.FTS')
n_fts_files=n_elements(fts_file_list)

; reading all FTS files
stat_read_fts_general_plot:
read_ondrejov_radio_B_FTS_file, fts_file_list, n_fts_files, $
                                data,time_ss,time_hh,frequencies, $
                                t1,t2,nt,dt,f1,f2,df,nf,$
                                date,time1,time2,t1_fod,t2_fod,n_min,$
                                hh1,mm1,ss1,hh2,mm2,ss2,$
                                station

data_general_save=data
bottom_save=min(data_general_save) & top_save=max(data_general_save)
data=data_general_save
bottom=min(data) & top=max(data)
t1_save=t1 & t2_save=t2 & t1_fod_save=t1_fod & t2_fod_save=t2_fod
time_ss_save=time_ss & time_hh_save=time_hh
nt_save=nt & n_min_save=n_min
time1_save=time1 & time2_save=time2
hh1_save=hh1 & mm1_save=mm1 & ss1_save=ss1
hh2_save=hh2 & mm2_save=mm2 & ss2_save=ss2
f1_save=f1 & f2_save=f2 & nf_save=nf
frequencies_save=frequencies

;help,fts_file_list, $
;     data,time_ss,time_hh,frequencies, $
;     t1,t2,nt,dt,f1,f2,df,nf
;print,t1,t2,nt,dt,f1,f2,df,nf
;print,date
;print,time1
;print,time2
;stop

; plot parameters 
key_plot=0
set_plot,'x'

; set of the dafault or previously set display parameters for generel plot
if key ne 11 then begin       ; default
  ; default display parameters
   window_width=1100
   aspect_ratio=0.45
   wset=0
   data_title=date+' '+station
   myxminor=6
   mycharsize=2.5
   plot_POSITION=[0.12,0.18,0.85,0.95]
   myxticklen=-0.03
   myyticklen=-0.01
   myxticks=n_min                
   divisions=10
   mycharsize_radio=2.5
   colorbar_radio_format='(i4)'
   cb_position_radio=[0.87,0.18,0.90,0.95]
   color_bar_axes_ticks=0
endif else begin
   ; already display parameters for general
   window_width=window_width_general
   aspect_ratio=aspect_ratio_general
   wset=wset_general
   myxminor=myxminor_general
   mycharsize=mycharsize_general
   plot_POSITION=plot_POSITION_general
   myxticklen=myxticklen_general
   myyticklen=myyticklen_general
   myxticks=myxticks_general                
   divisions=divisions_general
   mycharsize_radio=mycharsize_radio_general
   colorbar_radio_format=colorbar_radio_format_general
   cb_position_radio=cb_position_radio_general
   top=top_general
   bottom=bottom_general
endelse

; plot parameters 
lut_radio=5

;; font_adjustment_via_tmp_file_output_to_eps
;font_adjustment_via_tmp_file_output_to_eps

; general plot
stat_general_plot:
if key_plot ne 4 then window,0,xs=window_width,ys=window_width*aspect_ratio,$
                             xp=monitor_size(0)-window_width,yp=monitor_size(1),$
                             title='GENERAL PLOT'
; actions
; 1 - data range
data=(data>bottom)<top
; 2 - window aspect ratio
if key_plot ne 4 then window,0,xs=window_width,ys=window_width*aspect_ratio,$
                               xp=monitor_size(0)-window_width,yp=monitor_size(1),$
                             title='GENERAL PLOT'

; real plot
hm_line_time_2d_plot_equidistant, wset, data_title, $
   time_ss, frequencies, data, date,$
   time_hh/24.,$
   [max(frequencies),min(frequencies)],lut_radio,$
   xminor=myxminor,$
   charsize=mycharsize,charthick=2.0,position=plot_POSITION,$
   xticklen=myxticklen,yticklen=myyticklen,xticks=myxticks,$
   colorbar_radio_format=colorbar_radio_format;, font=-1

; colorbar
loadct,lut_radio,/silent,file='colors1.tbl'
displayColors=!D.N_COLORS
min_display=min(data) & max_display=max(data)
im=bytscl(data,min=min_display,max=max_display,top=displayColors-1)

COLORBAR_JR, CHARSIZE=mycharsize_radio, COLOR=color_bar_axes_ticks,charthick=2.0,$
             DIVISIONS=divisions,$
             FORMAT=colorbar_radio_format, $
             POSITION=cb_position_radio,$
             ;MAXRANGE=max(data),MINRANGE=min(data),$
             MAXRANGE=0,MINRANGE=255,$
             NCOLORS=256, $   
             TITLE='RADIO FLUX [a.u.]',$
             /VERTICAL, MINOR=minor,$
             RANGE=[min(data),max(data)],$
             ;, FONT=font, TICKLEN=ticklen, _EXTRA=extra,
             key_lut_reverse=0,  KEY_ALOG=0, /RIGHT;, font=-1

if key_plot eq 4 then begin
   mycharsize=mycharsize*3.
   mycharsize_radio=mycharsize_radio*3.
endif
if key_plot eq 4 then eps_to_jpeg, path_plots,pathfilename_out_core
if key_plot eq 4 then eps_output_end, key_plot,path_plots,pathfilename_out_core

; menu after general plot
stat_menu_general:
key=0
print
print,' INPUT: 0 - end'
print,'        1 - data range adjustment'
print,'        2 - LUT number'
print,'        3 - window aspect ratio change'
print,'        4 - x-ticks number'
print,'        5 - x-minorticks number'
print,'        6 - bar-ticks number'
print,'        7 - EPS + JPEG output files'
print,'       10 - zoom selection'
read,key,prompt='       key =  '
if key eq 0 then goto,stat_end
if key lt 0 or key gt 10 then goto,stat_menu_general
if key eq 1 then begin
   print
   print, ' INFO : total  data range: ['+strtrim(bottom_save)+','+$
                                         strtrim(top_save)+']'
   print, ' INFO : actual data range: ['+strtrim(bottom)+','+$
                                         strtrim(top)+']'
   read,bottom,top,prompt=' INPUT: data range - bottom,top = '
   data=data_general_save
   goto, stat_general_plot
endif
if key eq 2 then begin
   print
   print, ' INFO : current LUT number: '+strtrim(lut_radio)
   ;xloadct
   read,lut_radio,prompt=' INPUT: new LUT number = '
   goto, stat_general_plot
endif
if key eq 3 then begin
   print
   print, ' INFO : current window aspect ratio: '+strtrim(aspect_ratio)
   read,aspect_ratio,prompt=' INPUT: aspect_ratio = '
   goto, stat_general_plot
endif
if key eq 4 then begin
   print
   print, ' INFO : actual xtics number: '+strtrim(myxticks)
   read,myxticks,prompt=' INPUT: new xtics number = '
   goto, stat_general_plot
endif
if key eq 5 then begin
   print
   print, ' INFO : actual xminortics number: '+strtrim(myxminor)
   read,myxminor,prompt=' INPUT: new xminortics number = '
   goto, stat_general_plot
endif
if key eq 6 then begin
   print
   print, ' INFO : actual bar-ticks number: '+strtrim(divisions)
   read,divisions,prompt=' INPUT: new  bar-ticks number = '
   goto, stat_general_plot
endif
if key eq 7 then begin
   path_plots=strmid(path_data,0,strpos(path_data,'/',/reverse_search)-1)
   path_plots=strmid(path_plots,0,strpos(path_plots,'/',/reverse_search))+'/'
   path_plots=path_plots+'plots/'
   file_mkdir,path_plots
   key_plot=4
   ; font_adjustment_via_tmp_file_output_to_eps
   font_adjustment_via_tmp_file_output_to_eps
   key_plot=4                   ; eps 
   eps_output_start, key_plot,window_width,aspect_ratio,$
                     path_plots,pathfilename_out_core,$
                     date,time1,time2,f1,f2,lut_radio
   mycharsize=mycharsize/3.
   mycharsize_radio=mycharsize_radio/3.
   goto, stat_general_plot
endif
if key eq 10 then begin

   ; default display parameters saving
   window_width_general=window_width
   aspect_ratio_general=aspect_ratio
   wset_general=wset
   myxminor_general=myxminor
   mycharsize_general=mycharsize
   plot_POSITION_general=plot_POSITION
   myxticklen_general=myxticklen
   myyticklen_general=myyticklen
   myxticks_general=myxticks                
   divisions_general=divisions
   mycharsize_radio_general=mycharsize_radio
   colorbar_radio_format_general=colorbar_radio_format
   cb_position_radio_general=cb_position_radio
   bottom_general=bottom
   top_general=top

   ; new ranges interactively
   print
   stat_new_time_range:
   print, ' INFO : total time range: ['+$
          time1+'-'+time2+']'
   tmp=0
   read,hh1,mm1,ss1,prompt=' INPUT: time_START [HH,MM,SS] = '
   read,hh2,mm2,ss2,prompt=' INPUT: time_END   [HH,MM,SS] = '
   t1_fod=(hh1+mm1/60.+ss1/3600.)/24.
   t2_fod=(hh2+mm2/60.+ss2/3600.)/24.;+3./3600./24.
   if t1_fod lt t1_fod_save or t2_fod gt t2_fod_save then goto,stat_new_time_range
   stat_new_f_range:
   print, ' INFO : total frequency range: ['+$
            strtrim(f1_save,2)+'-'+strtrim(f2_save,2)+']'
   read,f1,f2,prompt=' INPUT: frequency rage (f1<f2) [MHz,MHz] = '
   if f1 lt f1_save or f2 gt f2_save then goto,stat_new_f_range
   ind_t=where(time_hh_save/24. ge t1_fod and time_hh_save/24. le t2_fod)
   ind_f=where(frequencies ge f1 and frequencies le f2)
   ; data
   data=data_general_save(ind_t,*)
   data=data(*,ind_f)
   data_zoom_save=data
   bottom=min(data) & top=max(data)
   bottom_zoom_save=bottom & top_zoom_save=top
   ; time
   time_ss=time_ss_save(ind_t)-time_ss_save(ind_t(0))
   t1=t1_fod*24. & t2=t2_fod*24.
   time_hh=time_ss/3600.+t1
   nt=n_elements(ind_t) & n_min=round((t2-t1)*60.)
   hh1_str=strtrim(hh1,2) & if hh1 lt 10 then hh1_str='0'+hh1_str
   mm1_str=strtrim(mm1,2) & if mm1 lt 10 then mm1_str='0'+mm1_str
   ss1_str=strtrim(ss1,2) & if ss1 lt 10 then ss1_str='0'+ss1_str
   hh2_str=strtrim(hh2,2) & if hh2 lt 10 then hh2_str='0'+hh2_str
   mm2_str=strtrim(mm2,2) & if mm2 lt 10 then mm2_str='0'+mm2_str
   ss2_str=strtrim(ss2,2) & if ss2 lt 10 then ss2_str='0'+ss2_str   
   time1=hh1_str+':'+mm1_str+':'+ss1_str
   time2=hh2_str+':'+mm2_str+':'+ss2_str
   ; f
   frequencies=frequencies(ind_f)   
   f1=frequencies(0) & f2=frequencies(n_elements(frequencies)-1)
   goto, stat_zoom
endif

stat_zoom:
; plot parameters 
key_plot=0
set_plot,'x'

; default display parameters
window_width=1100
aspect_ratio=0.45
wset=2
data_title=date+' '+station
;time_start=nst1_fod(0)*24.
;yy=strmid(date,0,4) & mm=strmid(date,4,2) & dd=strmid(date,6,2)
myxminor=6
mycharsize=2.5
plot_POSITION=[0.12,0.18,0.85,0.95]
myxticklen=-0.03
myyticklen=-0.01
myxticks=n_min                

DIVISIONS=10
mycharsize_radio=2.5
colorbar_radio_format='(i4)'
cb_position_radio=[0.87,0.18,0.90,0.95]

; plot parameters 
lut_radio=5

;; font_adjustment_via_tmp_file_output_to_eps
;font_adjustment_via_tmp_file_output_to_eps

; general plot
stat_zoom_plot:
if key_plot ne 4 then window,1,xs=window_width,ys=window_width*aspect_ratio,$
                      xp=monitor_size(0)-window_width,yp=0,$
                      title='ZOOM PLOT'
; actions
; 1 - data range
data=(data>bottom)<top
; 2 - window aspect ratio
if key_plot ne 4 then window,1,xs=window_width,ys=window_width*aspect_ratio,$
                      xp=monitor_size(0)-window_width,yp=0,$
                      title='ZOOM PLOT'
; real plot
hm_line_time_2d_plot_equidistant, wset, data_title, $
   time_ss, frequencies, data, date,$
   time_hh/24.,$
   [max(frequencies),min(frequencies)],lut_radio,$
   xminor=myxminor,$
   charsize=mycharsize,charthick=2.0,position=plot_POSITION,$
   xticklen=myxticklen,yticklen=myyticklen,xticks=myxticks,$
   colorbar_radio_format=colorbar_radio_format;, font=-1

; colorbar 
COLORBAR_JR, CHARSIZE=mycharsize_radio, COLOR=255,charthick=2.0,$
             DIVISIONS=divisions,$
             FORMAT=colorbar_radio_format, $
             POSITION=cb_position_radio,$
             MAXRANGE=max(data),MINRANGE=min(data),$
             NCOLORS=256, $   
             TITLE='RADIO FLUX [a.u.]',$
             /VERTICAL, MINOR=minor,$
             RANGE=[min(data),max(data)],$
             ;, FONT=font, TICKLEN=ticklen, _EXTRA=extra,
             key_lut_reverse=1,  KEY_ALOG=0, /RIGHT;, font=-1

if key_plot eq 4 then begin
   mycharsize=mycharsize*3.
   mycharsize_radio=mycharsize_radio*3.
endif
if key_plot eq 4 then eps_to_jpeg, path_plots,pathfilename_out_core
if key_plot eq 4 then eps_output_end, key_plot,path_plots,pathfilename_out_core

; menu after zool plot
stat_menu_zoom:
key=0
print
print,' INPUT: 0 - end'
print,'        1 - data range adjustment'
print,'        2 - LUT number'
print,'        3 - window aspect ratio change'
print,'        4 - x-ticks number'
print,'        5 - x-minorticks number'
print,'        6 - bar-ticks number'
print,'        7 - EPS + JPEG output files'
print,'       11 - back to general plot'
read,key,prompt='        key =  '
if key eq 0 then goto,stat_end
if key lt 0 or key gt 11 then goto,stat_menu_general
if key eq 1 then begin
   print
   print, ' INFO : total  data range: ['+strtrim(bottom_zoom_save)+','+$
                                         strtrim(top_zoom_save)+']'
   print, ' INFO : actual data range: ['+strtrim(bottom)+','+$
                                         strtrim(top)+']'
   read,bottom,top,prompt=' INPUT: data range - bottom,top = '
   ;data=data_general_save
   data=data_zoom_save
   goto, stat_zoom_plot
endif
if key eq 2 then begin
   print
   print, ' INFO : current LUT number: '+strtrim(lut_radio)
   ;xloadct
   read,lut_radio,prompt=' INPUT: new LUT number = '
   goto, stat_zoom_plot
endif
if key eq 3 then begin
   print
   print, ' INFO : current window aspect ratio: '+strtrim(aspect_ratio)
   read,aspect_ratio,prompt=' INPUT: aspect_ratio = '
   goto, stat_zoom_plot
endif
if key eq 4 then begin
   print
   print, ' INFO : actual xtics number: '+strtrim(myxticks)
   read,myxticks,prompt=' INPUT: new xtics number = '
   goto, stat_zoom_plot
endif
if key eq 5 then begin
   print
   print, ' INFO : actual xminortics number: '+strtrim(myxminor)
   read,myxminor,prompt=' INPUT: new xminortics number = '
   goto, stat_zoom_plot
endif
if key eq 6 then begin
   print
   print, ' INFO : actual bar-ticks number: '+strtrim(divisions)
   read,divisions,prompt=' INPUT: new  bar-ticks number = '
   goto, stat_zoom_plot
endif
if key eq 7 then begin
   path_plots=strmid(path_data,0,strpos(path_data,'/',/reverse_search)-1)
   path_plots=strmid(path_plots,0,strpos(path_plots,'/',/reverse_search))+'/'
   path_plots=path_plots+'plots/'
   file_mkdir,path_plots
   key_plot=4
   ; font_adjustment_via_tmp_file_output_to_eps
   font_adjustment_via_tmp_file_output_to_eps
   key_plot=4                   ; eps 
   eps_output_start, key_plot,window_width,aspect_ratio,$
                     path_plots,pathfilename_out_core,$
                     date,time1,time2,f1,f2,lut_radio
   mycharsize=mycharsize/3.
   mycharsize_radio=mycharsize_radio/3.
   goto, stat_zoom_plot
endif
if key eq 11 then begin
   goto, stat_read_fts_general_plot
endif

stat_end:
print
print,' END...'
print
end
