;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

PRO start_idl

!X.STYLE=1
!Y.STYLE=1
!Z.STYLE=1

!x.thick=2 & !y.thick=2
!p.thick=2

!P.TICKLEN=1./30.

!P.FONT=0

device,retain=2
Device, Decomposed=0

return
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

PRO start_headline

  print
  print,' RADIOSPECTROGRAMS VISUALIZATION'
  print
  print,' ONDREJOV A or B: sets of FITS files or a single SAV file'
  print,' CALLISTO       : sets of FITS files or a single SAV file'
  print,' ANY SOURCE     :                       a single SAV file'   
  print

return
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

PRO path_ondrejov_radio_B_FTS_files, path_data
  
cd,current=path_0
path_data=strmid(path_0,0,strpos(path_0,'/',/reverse_search))
path_data=strmid(path_data,0,strpos(path_0,'/',/reverse_search))
path_data=path_data+'/data/'
path_data=dialog_pickfile(path=path_data,filter=['*.fts','*.FTS'], $
                          TITLE='Choose directory with BYYMMDD.FTS files')

return
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

PRO    path_callisto_radio_SAV_adapted_file, path_data
  
cd,current=path_0
path_data=strmid(path_0,0,strpos(path_0,'/',/reverse_search))
path_data=strmid(path_data,0,strpos(path_0,'/',/reverse_search))
path_data=path_data+'/data/'
path_data=dialog_pickfile(path=path_data,filter=['*.sav','*.SAV'], $
                          TITLE='Choose directory with CALLISTO SAV file')

return
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

PRO path_filenames_input_files, path_data, filenames

; directory
cd,current=path_0
path_data=strmid(path_0,0,strpos(path_0,'/',/reverse_search))
path_data=strmid(path_data,0,strpos(path_0,'/',/reverse_search))
path_data=path_data+'/data/'
path_data=dialog_pickfile(path=path_data,$
                          TITLE='Choose directory with prepared FITS or SAV files')
; filenames
filenames = FILE_SEARCH(path_data, '*')

return
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

PRO selection_of_a_source_from_pathfilenames, filenames, key_data_source

; key_data_source = 1 : OND A or B FTS set of files
; key_data_source = 2 : CALLISTO fit   set of files
; key_data_source = 3 : any SAV/sav file with the adapted data by JR soft

; an automatic selection of a source
path_filename_tmp=filenames(0)
filename_tmp=strmid(path_filename_tmp,strpos(path_filename_tmp,'/',/reverse_search)+1,1000)
filename_tmp_1st_character=strmid(filename_tmp,0,1)
filename_tmp_extension=strmid(filename_tmp,strpos(filename_tmp,'.',/reverse_search)+1,1000)

; OND A or B FTS set of files
if (filename_tmp_1st_character eq 'A' or filename_tmp_1st_character eq 'B') $
   and  filename_tmp_extension eq 'FTS'  then key_data_source=1
; OND OND*.fit long files
if filename_tmp_1st_character eq 'O' $
   and  filename_tmp_extension eq 'fit'  then begin
   key_data_source=21
   goto, stat_return
endif

; CALLISTO set of fit files
if filename_tmp_extension eq 'fit' then key_data_source=2

; SAV or sav file of the radiospectrogram adapted data by JR codes
if filename_tmp_extension eq 'sav' or filename_tmp_extension eq 'SAV' or $
   filename_tmp_extension eq 'xdr' or filename_tmp_extension eq 'XDR' then key_data_source=3

stat_return:
return
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

PRO read_ondrejov_radio_B_FTS_file, filenames, n_fts_files, $
                                    data,time_ss,time_hh,frequencies, $
                                    t1,t2,nt,dt,f1,f2,df,nf,$
                                    date,time1,time2,t1_fod,t2_fod,n_min,$
                                    hh1,mm1,ss1,hh2,mm2,ss2,$
                                    station
  
for f=0,n_fts_files-1 do begin

   fits_read,filenames(f),d,h

   if f eq 0 then begin
      date=sxpar(h,'DATE') ; DD.MM.YY
      date=strmid(date,6,4)+strmid(date,3,2)+strmid(date,0,2) ; YYYYMMDD
      nt_one=sxpar(h,'XMAX')-sxpar(h,'XMIN')+1
      nt=nt_one*(n_fts_files) & nf=sxpar(h,'YMAX')-sxpar(h,'YMIN')+1
      data=intarr(nt,nf)
   endif
   if f eq 0 then begin
      x1=sxpar(h,'XMIN') & x2=sxpar(h,'XMAX') & y1=sxpar(h,'YMIN') & y2=sxpar(h,'YMAX')
      ;data(nt_one*f:nt_one*(f+1)-1,*)=rebin($
      ;                 d(sxpar(h,'XMIN'):sxpar(h,'XMAX'),$
      ;                 sxpar(h,'YMIN'):sxpar(h,'YMAX')),$
      ;                 nt_one/1.,sxpar(h,'YMAX')-sxpar(h,'YMIN')+1)
      tmp=d(x1:x2,y1:y2)
      data(nt_one*f:nt_one*(f+1)-1,*)=rebin(tmp,nt_one,sxpar(h,'YMAX')-sxpar(h,'YMIN')+1)
      shift_x0=0
      tmp1=sxpar(h,'TIME1')
      time1=tmp1
      hh1=fix(strmid(tmp1,0,2))
      mm1=fix(strmid(tmp1,3,2))
      ss1=fix(strmid(tmp1,6,2))
      t1=hhmmss_fod(hh1,mm1,ss1)*24. ; [HH.HH]
      tmp1=sxpar(h,'RATE') & tmp2=sxpar(h,'INTEG')
      ;print,tmp1,tmp2
      ;stop
      dt=1.d / double(tmp1) * double(tmp2) ;[s]      
   endif else begin
      data(nt_one*(f)+shift_x0:nt_one*(f+1)+shift_x0-1,*)=$
          d(sxpar(h,'XMIN'):sxpar(h,'XMAX'),sxpar(h,'YMIN'):sxpar(h,'YMAX'))
   endelse
      if f ne 0 then data(nt_one*(f+1-1)+shift_x0-1,*)=data(nt_one*(f+1-1)+shift_x0-1-1,*)
      
endfor

tmp2=sxpar(h,'TIME2')
time2=tmp2
hh2=fix(strmid(tmp2,0,2))
mm2=fix(strmid(tmp2,3,2))
ss2=fix(strmid(tmp2,6,2))

; final parameters
nt=n_elements(data(*,0))
;t1_fod=fltarr(1) & t2_fod=fltarr(1)
t1_fod=(float(hh1)+float(mm1)/60.+float(ss1)/3600.)/24.d
t2=(hhmmss_fod(hh1,mm1,ss1))*24.d
time_ss=findgen(nt)*dt          ; [s]
t2_fod=(float(hh2)+float(mm2)/60.+float(ss2)/3600.)/24.d
t2=(hhmmss_fod(hh2,mm2,ss2))*24.d
; corr - an extension for good time axis
dtf=dt
time_ss=[time_ss,max(time_ss)+dtf]
data=[data,data(n_elements(data(*,0))-1,*)]
nt=n_elements(data(*,0))
; final parameters
time_hh=time_ss/3600.+t1 ; UT      

; number of minutes
n_min=5 ;round((t2_fod-t1_fod)*60.)

;frequencies [MHz] 
frequencies=fltarr(nf) 
f2=sxpar(h,'FMAX') & f1=sxpar(h,'FMIN')
df=(f2-f1)/float(nf-1) 
for f=0,nf-1 do begin
   frequencies(f)=f2-f*df
endfor

station='ONDREJOV'

return
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

PRO read_ondrejov_radio_O_FTS_file, filenames, n_fts_files, $
                                    data,time_ss,time_hh,frequencies, $
                                    t1,t2,nt,dt,f1,f2,df,nf,$
                                    date,time1,time2,t1_fod,t2_fod,n_min,$
                                    hh1,mm1,ss1,hh2,mm2,ss2,$
                                    station
  
for f=0,n_fts_files-1 do begin

   fits_read,filenames(f),d,h
 
   if f eq 0 then begin
      date=sxpar(h,'DATE-OBS') ; '2011/05/30'
      date=strmid(date,0,4)+strmid(date,5,2)+strmid(date,8,2) ; YYYYMMDD
      nt_one=sxpar(h,'NAXIS1')
      nt=nt_one*(n_fts_files) & nf=sxpar(h,'NAXIS2')
      data=intarr(nt,nf)
   endif
   if f eq 0 then begin      
      data(nt_one*f:nt_one*(f+1)-1,*)=d
      shift_x0=0
      tmp1=sxpar(h,'TIME-OBS') ; '05:47:22'
      time1=tmp1
      hh1=fix(strmid(tmp1,0,2))
      mm1=fix(strmid(tmp1,3,2))
      ss1=fix(strmid(tmp1,6,2))
      t1=hhmmss_fod(hh1,mm1,ss1)*24. ; [HH.HH]
      tmp1=sxpar(h,'RATE') & tmp2=sxpar(h,'INTEG')
      ;print,hh1,mm1,ss1,tmp1,tmp2
      ;stop
      dt=1.d / double(tmp1) * double(tmp2) ;[s]      
   endif else begin
      data(nt_one*(f)+shift_x0:nt_one*(f+1)+shift_x0-1,*)=d
   endelse
;      if f ne 0 then data(nt_one*(f+1-1)+shift_x0-1,*)=data(nt_one*(f+1-1)+shift_x0-1-1,*)

endfor

; upside-down
data=rotate(data,7)

; data
tmp2=sxpar(h,'TIME-END') ; '05:48:07'
time2=tmp2
hh2=fix(strmid(tmp2,0,2))
mm2=fix(strmid(tmp2,3,2))
ss2=fix(strmid(tmp2,6,2))

; final parameters
nt=n_elements(data(*,0))
;t1_fod=fltarr(1) & t2_fod=fltarr(1)
t1_fod=(float(hh1)+float(mm1)/60.+float(ss1)/3600.)/24.d
t2=(hhmmss_fod(hh1,mm1,ss1))*24.d
time_ss=findgen(nt)*dt          ; [s]
t2_fod=(float(hh2)+float(mm2)/60.+float(ss2)/3600.)/24.d
t2=(hhmmss_fod(hh2,mm2,ss2))*24.d
; corr - an extension for good time axis
dtf=dt
time_ss=[time_ss,max(time_ss)+dtf]
data=[data,data(n_elements(data(*,0))-1,*)]
nt=n_elements(data(*,0))
; final parameters
time_hh=time_ss/3600.+t1 ; UT      

; number of minutes
n_min=5 ;round((t2_fod-t1_fod)*60.)

;frequencies [MHz] 
frequencies=fltarr(nf) 
f2=sxpar(h,'FREQ-MAX') & f1=sxpar(h,'FREQ-MIN')
df=(f2-f1)/float(nf-1) 
for f=0,nf-1 do begin
   frequencies(f)=f2-f*df
endfor

station='ONDREJOV'

return
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

PRO read_callisto_radio_fit_file,   filenames, n_fts_files, $
                                    data,time_ss,time_hh,frequencies, $
                                    t1,t2,nt,dt,f1,f2,df,nf,$
                                    date,time1,time2,t1_fod,t2_fod,n_min,$
                                    hh1,mm1,ss1,hh2,mm2,ss2,$
                                    station

;  variable renaming
file_list=filenames
  
for ff=0,n_elements(file_list)-1 do begin

   ; from SSW@penumbra.astro.sk: /usr/local/ssw/radio/ethz/idl/atest/
   ;                             radio_spectro_fits_read.pro
   radio_spectro_fits_read,file_list(ff),d,t,f,MAIN_HEADER=main_header

   ;help,main_header           
   ;** Structure <45a3768>, 39 tags, length=856, data length=836, refs=1:
   
   ;frequencies [MHz] ; as original CALLISTO fit has negative df...
   frequencies=f  
   f2=frequencies(n_elements(frequencies)-1)
   f1=frequencies(0)
   tmp=frequencies-shift(frequencies,1) & df=mean(tmp(1:*))
   nf=n_elements(frequencies)
   ;print,f2,f1,df,nf
   
   ; time [s]
   nt=n_elements(t)                
   t1=main_header.crval1/3600.d  ;[sec of day] -> UT HH.HH
   dt=main_header.cdelt1        ;[s]
   t2=t1+float(nt-1)*dt/3600.d
   t_ss=findgen(nt)*dt          ; [s]
   t_hh=t_ss/3600.+t1           ; UT
   ;print,ff,' ',nt,' ',t1,' ',t2,' ',dt
   
   ; merging
   if ff eq 0 then begin
      data=fltarr(n_elements(file_list)*nt,nf)
      time_ss=fltarr(n_elements(file_list)*nt)
      time_hh=fltarr(n_elements(file_list)*nt)
      time_ca=dblarr(n_elements(file_list)*nt)
   endif
   
   data(ff*nt:(ff+1)*nt-1,*)=d
   time_hh(ff*nt:(ff+1)*nt-1)=t_hh
   time_ca(ff*nt:(ff+1)*nt-1)=t

endfor                          ; end of FITS file reading cycle

; time/freq/data vectors
time_ss=(time_hh-time_hh(0))*3600.
time_ss_raw=time_ss
time_hh_raw=time_hh
time_ca_raw=time_ca
frequencies_raw=frequencies
data_raw=data

; callisto BIR 20220328 11:15-11:30 data case
;data=[data,data(n_elements(data(*,0))-1,*),data(n_elements(data(*,0))-1,*)]
;time_ss=[time_ss,time_ss(n_elements(time_ss)-1)+dt,time_ss(n_elements(time_ss)-1)+2.*dt]
;time_hh=[time_hh,time_hh(n_elements(time_hh)-1)+dt/3600.,time_hh(n_elements(time_hh)-1)+2.*dt/3600.]
;data=data-1.

; unigue frequencies and data only
; b = array[UNIQ(array, SORT(array))]
fr=frequencies
data  = data(*,UNIQ(frequencies))
frequencies = frequencies(UNIQ(frequencies))

; recalculation of f parameters
f2=frequencies(n_elements(frequencies)-1)
f1=frequencies(0)
tmp=f2 & f2=f1 & f1=tmp
tmp=frequencies-shift(frequencies,1) & df=abs(mean(tmp(1:*)))
nf=n_elements(frequencies)

; other parameters calculation for the output SAV file
date=main_header.date
date=strmid(date,0,4)+strmid(date,5,2)+strmid(date,8,2) ;YYYYMMDD
t1=time_hh(0)
t1_fod=time_hh(0)/24.
t2_fod=max(time_hh)/24.
fod_hhmmss, t1_fod,hh,mm,ss
hh1=strtrim(hh,2) & if hh lt 10 then hh1='0'+hh1
mm1=strtrim(mm,2) & if mm lt 10 then mm1='0'+mm1
ss1=strtrim(ss,2) & if ss lt 10 then ss1='0'+ss1
time1=hh1+':'+mm1+':'+ss1
fod_hhmmss, t2_fod,hh,mm,ss
hh2=strtrim(hh,2) & if hh lt 10 then hh2='0'+hh2
mm2=strtrim(mm,2) & if mm lt 10 then mm2='0'+mm2
ss2=strtrim(ss,2) & if ss lt 10 then ss2='0'+ss2
time2=hh2+':'+mm2+':'+ss2
;print,t1,' ',t1_fod,' ',hh1,' ',mm1,' ',ss1,' ',time1
;print,t2,' ',t2_fod,' ',hh2,' ',mm2,' ',ss2,' ',time2
nt=n_elements(data(*,0))
; number of minutes
n_min=5 ;round((t2_fod-t1_fod)*60.)

station='CALLISTO_'+main_header.INSTRUME

return
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

PRO read_radio_adapted_SAV_file, filename, n_fts_files, $
                                          data,time_ss,time_hh,frequencies, $
                                          t1,t2,nt,dt,f1,f2,df,nf,$
                                          date,time1,time2,t1_fod,t2_fod,n_min,$
                                          hh1,mm1,ss1,hh2,mm2,ss2,$
                                 station
  
restore,filename,/ver

stop

;hh1=13
;mm1=50
;ss1=00
;hh2=14
;mm2=10
;ss2=00
;TIME1='13:50:00'
;TIME2='14:10:00'


; corr - an extension for good time axis
;dtf1=-3.0 & dtf2=3.0
;t1_fod=(float(hh1)+float(mm1)/60.+float(ss1)/3600.+dtf1/3600.)/24.
;t2_fod=(float(hh2)+float(mm2)/60.+float(ss2)/3600.+dtf2/3600.)/24.
;;time1=t1_fod*24.
;;time2=t2_fod*24.

;datat=[data(0,*),data(0,*),data(0,*),data,data(nt-1,*),data(nt-1,*),data(nt-1,*)]
;nt=nt+6

;data=datat

;time_ss=findgen(nt)*dt-3.*dt
;;time_ss(nt-1)=time_ss(nt-1)+dtf2*dt

; final parameters
;time_hh=time_ss/3600.+t1;-3.*dt/3600. ; UT      
n_min=5

; recalculation of f parameters
f2=frequencies(n_elements(frequencies)-1)
f1=frequencies(0)
tmp=f2 & f2=f1 & f1=tmp
tmp=frequencies-shift(frequencies,1) & df=abs(mean(tmp(1:*)))
nf=n_elements(frequencies)
;print,f2,f1,df,nf

return
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

PRO radio_data_rounding_to_full_SS, data, time_ss, time_hh, $
                                    t1,t2,nt,dt,$
                                    time1,time2,t1_fod,t2_fod,$
                                    hh1,mm1,ss1,hh2,mm2,ss2

; rounding to full SS time limits

; time_hh [HH.HH]
ss_input_interval=time_hh*3600. ; DOUBLE - input SS.SS since midnight
ns_ss_input_interval=n_elements(ss_input_interval)
ss_input_interval_start=ss_input_interval(0)
ss_input_interval_end  =ss_input_interval(ns_ss_input_interval-1)

; full_day_ss_axis
ss_full_day_axis=double(findgen(24.*3600.)) ; DOUBLE - full day SS.SS since midnight

; index input ss in full_day SS
index_ss_in=where (ss_full_day_axis ge ss_input_interval_start and $
                   ss_full_day_axis le ss_input_interval_end       )

; check 1st if full/non-fractional SS
;if ss_full_day_axis(index_ss_in(0)) eq ss_input_interval_start then goto, stat_to_check_last

time_hh(0)=float(hh1)+float(mm1)/60.+float(ss1)/3600. 
times_ss=findgen(n_elements(data(*,0)))
t1_fod=time_hh(0)/24.d
t1=time_hh(0)
goto,stat_test1

; adding a number to time axis before the 1st input value and calc it
; time value
index_to_add_before_1st=index_ss_in(0)-1
time_diff_1st_add_ss=ss_input_interval(0)-ss_full_day_axis(index_to_add_before_1st)
; adding values to this index
size_data=size(data)
data_tmp=fltarr(size_data(1)+1,size_data(2))
data_tmp(0,*)=data(0,*)
data_tmp(1:*,*)=data
data=data_tmp
;
time_ss=[0.0,time_ss+1]
time_hh=[time_hh(0)-time_diff_1st_add_ss/3600.,time_hh];-time_diff_1st_add_ss/3600.,time_hh]
t1=time_hh(0)
t1_fod=t1/24.d
; hh1,mm1,ss1
stat_test1:

stat_to_check_last:
; check last if full/non-fractional SS
;if ss_full_day_axis(index_ss_in(n_elements(index_ss_in)-1)) eq ss_input_interval_end then goto, stat_no_need_add_last

time_hh(n_elements(time_hh)-1)=float(hh2)+float(mm2)/60.+float(ss2)/3600.
times_ss=findgen(n_elements(data(*,0)))
t2_fod=time_hh(n_elements(time_hh)-1)/24.d
t2=max(time_hh)
goto,stat_test2

; adding a number to time axis after the last input value and calc it
; time value
index_to_add_after_last=index_ss_in(n_elements(index_ss_in)-1)+1
time_diff_last_add_ss=ss_full_day_axis(index_to_add_after_last)-ss_input_interval(n_elements(ss_input_interval)-1)
; adding values to this index
size_data=size(data)
data_tmp=fltarr(size_data(1)+1,size_data(2))
data_tmp(size_data(1),*)=data(size_data(1)-1,*)
data_tmp(0:size_data(1)-1,*)=data
data=data_tmp
time_ss=[time_ss,time_ss(size_data(1)-1)+time_diff_last_add_ss]
time_hh=[time_hh,time_hh(size_data(1)-1)+time_diff_last_add_ss/3600.]
t2=time_hh(n_elements(time_hh)-1)
t2_fod=t2/24.
; hh2,mm2,ss2
stat_test2:

stat_no_need_add_last:

return
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

PRO font_adjustment_via_tmp_file_output_to_eps

key_plot=4 ; eps 
; output file open
pathfilename_out='fig_tmp_due_to_font'
window_plot_save_start_jr,key_plot,window_index=0,$
       window_title='RADIOSPECTROGRAM',$
       window_size=[1000*1.1,540]*1.25,pathfilename_out=pathfilename_out
plot,findgen(100),title='x'
; output close
window_plot_save_end_jr, key_plot, pathfilename_out=pathfilename_out
; removal
spawn,'rm fig_tmp_due_to_font.eps'

return
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

PRO eps_output_start, key_plot,window_width,aspect_ratio,$
                      path_plots,pathfilename_out_core,$
                      date,time1,time2,f1,f2,lut,station

pathfilename_out_core=''
print
; finemaout 1st part: date,time,fre,lut
pathfilename_out_start=date+'_'+time1+'-'+time2+'_'+$
                       strtrim(round(f1),2)+'-'+strtrim(round(f2),2)+'_'+station+'_'+$
                       'lut_'+strtrim(lut,2)
print,' INFO : EPS/JPEG output filename beginning = '+pathfilename_out_start
pathfilename_out_add=''
read,pathfilename_out_add,prompt=' INPUT: EPS/JPEG output filename addition = '
if pathfilename_out_add ne '' then begin
   under_tmp='_'
endif else begin
   under_tmp=''
endelse   
pathfilename_out_core=pathfilename_out_start+under_tmp+pathfilename_out_add
window_plot_save_start_jr,key_plot,window_index=0,$
                          window_size=window_width*[1.,aspect_ratio]*1.5,$
                          pathfilename_out=path_plots+pathfilename_out_core

return
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

PRO eps_output_end, key_plot,path_plots,pathfilename_out_core

window_plot_save_end_jr, key_plot,pathfilename_out=path_plots+pathfilename_out_core

key_plot=0

return
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

PRO eps_to_jpeg, path_plots,pathfilename_out_core
  
; eps -> jpg
print,' JPEG output of the plot/image...'
spawn,'convert -density 600x600 '+path_plots+pathfilename_out_core+'.eps'+' '$
                                 +path_plots+pathfilename_out_core+'.jpg'

return
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

; RADIOSPECTROGRAMS VISUALIZATION

; ONDREJOV A and B - a set of FITS files or a single SAV file
; CALLISTO - a set of fit files or a single SAV file
; ORFEES   - a SAV file

; JR, 2023/07/12, v.13

; start_idl
start_idl

; start parameters
key=0

; start_headline
start_headline

; monitor size
device,get_SCREEN_SIZE=monitor_size

; directory selection
key_data_source=0
; automatic selection of a source
; path + filenames
path_filenames_input_files, path_data, filenames

; selection of a source
selection_of_a_source_from_pathfilenames, filenames, key_data_source

; OND 1 or B FTS set
if (key_data_source eq 1) or (key_data_source eq 21) then begin
   ; FTS file list
   fts_file_list=filenames
   n_fts_files=n_elements(fts_file_list)
   ; reading all FTS files
   stat_read_fts_general_plot:
   ; Ondrejov or other FTS
   strpos_lom=strpos(fts_file_list(0),'/',/reverse_search)+1
   filename_only=strmid(fts_file_list(0),strpos_lom,200)
endif

;; OND 1 or B FTS set
;if key_data_source eq 21 then begin
;   ; FTS file list
;   fts_file_list=filenames
;   n_fts_files=n_elements(fts_file_list)
;   ; reading all FTS files
;   stat_read_fts_general_plot:
;   ; Ondrejov or other FTS
;   strpos_lom=strpos(fts_file_list(0),'/',/reverse_search)+1
;   filename_only=strmid(fts_file_list(0),strpos_lom,200)
;endif

if key_data_source eq 2 then begin ; CALLISTO fit files set
   ; FTS file list
   fts_file_list=filenames
   n_fts_files=n_elements(fts_file_list)
   ; reading all FTS files
   stat_read_fit_general_plot:
   ; Ondrejov or other FTS
   strpos_lom=strpos(fts_file_list(0),'/',/reverse_search)+1
   filename_only=strmid(fts_file_list(0),strpos_lom,200)
endif

if key_data_source eq 3 then begin
   ; SAV file of any source
   sav_file_list=file_search(path_data,'*.sav')
   n_sav_files=1
   sav_file=sav_file_list(n_sav_files-1)
   ; callisto SAV file
   stat_read_sav_general_plot:
   strpos_lom=strpos(sav_file_list(0),'/',/reverse_search)+1
   filename_only=strmid(sav_file_list(0),strpos_lom,200)
endif

; ONDREJOV A or B FTS files sets
if key_data_source eq 1 then begin
   read_ondrejov_radio_B_FTS_file, fts_file_list, n_fts_files, $
                                data,time_ss,time_hh,frequencies, $
                                t1,t2,nt,dt,f1,f2,df,nf,$
                                date,time1,time2,t1_fod,t2_fod,n_min,$
                                hh1,mm1,ss1,hh2,mm2,ss2,$
                                station
endif

; ONDREJOV long OND*.fit files sets
if key_data_source eq 21 then begin
   read_ondrejov_radio_O_FTS_file, fts_file_list, n_fts_files, $
                                data,time_ss,time_hh,frequencies, $
                                t1,t2,nt,dt,f1,f2,df,nf,$
                                date,time1,time2,t1_fod,t2_fod,n_min,$
                                hh1,mm1,ss1,hh2,mm2,ss2,$
                                station
endif

; CALLISTO set of fit files
if key_data_source eq 2 then begin
   read_callisto_radio_fit_file, fts_file_list, n_fts_files, $
                                data,time_ss,time_hh,frequencies, $
                                t1,t2,nt,dt,f1,f2,df,nf,$
                                date,time1,time2,t1_fod,t2_fod,n_min,$
                                hh1,mm1,ss1,hh2,mm2,ss2,$
                                station
endif
   
; SAV file of adapted data
if key_data_source eq 3 then begin
   read_radio_adapted_SAV_file, sav_file, n_sav_files, $
                                         data,time_ss,time_hh,frequencies, $
                                         t1,t2,nt,dt,f1,f2,df,nf,$
                                         date,time1,time2,t1_fod,t2_fod,n_min,$
                                         hh1,mm1,ss1,hh2,mm2,ss2,$
                                         station
   
endif

; common for all FITS files
data_general_save=data
bottom_save=min(data_general_save) & top_save=max(data_general_save)
bottom=min(data) & top=max(data)
t1_save=t1 & t2_save=t2 & t1_fod_save=t1_fod & t2_fod_save=t2_fod
time_ss_save=time_ss & time_hh_save=time_hh
nt_save=nt & n_min_save=n_min
time1_save=time1 & time2_save=time2
hh1_save=hh1 & mm1_save=mm1 & ss1_save=ss1
hh2_save=hh2 & mm2_save=mm2 & ss2_save=ss2
f1_save=f1 & f2_save=f2 & nf_save=nf
frequencies_save=frequencies

; info printing
print,' INFO: files read to 2D radiospectrogram variables:'
print
if key_data_source eq 1 or key_data_source eq 2 then begin
   for f=0,n_fts_files-1 do begin
      print,'   '+strtrim(f+1,2)+'  '+fts_file_list(f)
   endfor
endif
if key_data_source eq 3 then begin
      print,'   '+strtrim(n_sav_files,2)+'  '+sav_file
endif
print

; plot parameters 
print,' PLOTTING GENERAL PLOT...'
key_plot=0
set_plot,'x'

; set of the dafault or previously set display parameters for generel plot
if key ne 11 then begin       ; default
  ; default display parameters
   window_width=1100
   aspect_ratio=0.45
   wset=0
   data_title=date+' '+station
   myxminor=10
   mycharsize=2.5
   plot_POSITION=[0.12,0.18,0.85,0.95]
   myxticklen=-0.03
   myyticklen=-0.01
   myxticks=round(max(time_ss))
   if myxticks gt 6 then begin
      for k=2,1000-1 do begin
         myxticks=round(max(time_ss)/float(k))
         if myxticks le 6 then goto,stat_good_mi
      endfor
      stat_good_mi:
   endif
   divisions=10
   mycharsize_radio=2.5
   colorbar_radio_format='(i4)'
   cb_position_radio=[0.87,0.18,0.90,0.95]
   color_bar_axes_ticks=0
endif else begin
   ; already display parameters for general
   window_width=window_width_general
   aspect_ratio=aspect_ratio_general
   wset=wset_general
   myxminor=myxminor_general
   mycharsize=mycharsize_general
   plot_POSITION=plot_POSITION_general
   myxticklen=myxticklen_general
   myyticklen=myyticklen_general
   myxticks=myxticks_general                
   divisions=divisions_general
   mycharsize_radio=mycharsize_radio_general
   colorbar_radio_format=colorbar_radio_format_general
   cb_position_radio=cb_position_radio_general
   top=top_general
   bottom=bottom_general
endelse

; plot parameters 
lut_radio=5
loadct,lut_radio,/silent,file='colors1.tbl'

;; font_adjustment_via_tmp_file_output_to_eps
;font_adjustment_via_tmp_file_output_to_eps

; general plot
stat_general_plot:
if key_plot ne 4 then window,0,xs=window_width,ys=window_width*aspect_ratio,$
                               xp=monitor_size(0)-window_width,yp=monitor_size(1),$
                               title='GENERAL PLOT'
; actions
; 1 - data range
data=(data>bottom)<top
; 2 - window aspect ratio
if key_plot ne 4 then window,0,xs=window_width,ys=window_width*aspect_ratio,$
                               xp=monitor_size(0)-window_width,yp=monitor_size(1),$
                               title='GENERAL PLOT'

; real plot
hm_line_time_2d_plot_equidistant, wset, data_title, $
   time_ss, frequencies, data, date,$
   time_hh/24.,$
   [max(frequencies),min(frequencies)],lut_radio,$
   xminor=myxminor,$
   charsize=mycharsize,charthick=2.0,position=plot_POSITION,$
   xticklen=myxticklen,yticklen=myyticklen,xticks=myxticks,$
   colorbar_radio_format=colorbar_radio_format,key_smoo_nonsmo=key_sns;, font=-1

; colorbar
loadct,lut_radio,/silent,file='colors1.tbl'
displayColors=!D.N_COLORS
min_display=min(data) & max_display=max(data)
im=bytscl(data,min=min_display,max=max_display,top=displayColors-1)

COLORBAR_JR, CHARSIZE=mycharsize_radio, COLOR=color_bar_axes_ticks,charthick=2.0,$
             DIVISIONS=divisions,$
             FORMAT=colorbar_radio_format, $
             POSITION=cb_position_radio,$
             ;MAXRANGE=max(data),MINRANGE=min(data),$
             MAXRANGE=0,MINRANGE=255,$
             NCOLORS=256, $   
             TITLE='RADIO FLUX [a.u.]',$
             /VERTICAL, MINOR=minor,$
             RANGE=[min(data),max(data)],$
             ;, FONT=font, TICKLEN=ticklen, _EXTRA=extra,
             key_lut_reverse=0,  KEY_ALOG=0, /RIGHT;, font=-1

if key_plot eq 4 then begin
   mycharsize=mycharsize*3.
   mycharsize_radio=mycharsize_radio*3.
endif
if key_plot eq 4 then eps_to_jpeg, path_plots,pathfilename_out_core
if key_plot eq 4 then eps_output_end, key_plot,path_plots,pathfilename_out_core

; menu after general plot
stat_menu_general:
key=0
print
print,' INPUT: 0 - end'
print,'        1 - data range adjustment'
print,'        2 - LUT number'
print,'        3 - window aspect ratio change'
print,'        4 - x-ticks number'
print,'        5 - x-minorticks number'
print,'        6 - bar-ticks number'
print,'        7 - EPS + JPEG output files'
print,'       10 - zoom selection'
read,key,prompt='       key =  '
if key eq 0 then goto,stat_end
if key lt 0 or key gt 10 then goto,stat_menu_general
if key eq 1 then begin
   print
   print, ' INFO : total  data range: ['+strtrim(bottom_save)+','+$
                                         strtrim(top_save)+']'
   print, ' INFO : actual data range: ['+strtrim(bottom)+','+$
                                         strtrim(top)+']'
   read,bottom,top,prompt=' INPUT: data range - bottom,top = '
   data=data_general_save
   goto, stat_general_plot
endif
if key eq 2 then begin
   print
   print, ' INFO : current LUT number: '+strtrim(lut_radio)
   ;xloadct
   read,lut_radio,prompt=' INPUT: new LUT number = '
   goto, stat_general_plot
endif
if key eq 3 then begin
   print
   print, ' INFO : current window aspect ratio: '+strtrim(aspect_ratio)
   read,aspect_ratio,prompt=' INPUT: aspect_ratio = '
   goto, stat_general_plot
endif
if key eq 4 then begin
   print
   print, ' INFO : actual xtics number: '+strtrim(myxticks)
   read,myxticks,prompt=' INPUT: new xtics number = '
   goto, stat_general_plot
endif
if key eq 5 then begin
   print
   print, ' INFO : actual xminortics number: '+strtrim(myxminor)
   read,myxminor,prompt=' INPUT: new xminortics number = '
   goto, stat_general_plot
endif
if key eq 6 then begin
   print
   print, ' INFO : actual bar-ticks number: '+strtrim(divisions)
   read,divisions,prompt=' INPUT: new  bar-ticks number = '
   goto, stat_general_plot
endif
if key eq 7 then begin
   path_plots=strmid(path_data,0,strpos(path_data,'/',/reverse_search)-1)
   path_plots=strmid(path_plots,0,strpos(path_plots,'/',/reverse_search))+'/'
   path_plots=path_plots+'plots/'
   file_mkdir,path_plots
   key_plot=4
   ; font_adjustment_via_tmp_file_output_to_eps
   font_adjustment_via_tmp_file_output_to_eps
   key_plot=4                   ; eps 
   eps_output_start, key_plot,window_width,aspect_ratio,$
                     path_plots,pathfilename_out_core,$
                     date,time1,time2,f1,f2,lut_radio,station
   mycharsize=mycharsize/3.
   mycharsize_radio=mycharsize_radio/3.
   goto, stat_general_plot
endif
if key eq 10 then begin

   ; default display parameters saving
   window_width_general=window_width
   aspect_ratio_general=aspect_ratio
   wset_general=wset
   myxminor_general=myxminor
   mycharsize_general=mycharsize
   plot_POSITION_general=plot_POSITION
   myxticklen_general=myxticklen
   myyticklen_general=myyticklen
   myxticks_general=myxticks                
   divisions_general=divisions
   mycharsize_radio_general=mycharsize_radio
   colorbar_radio_format_general=colorbar_radio_format
   cb_position_radio_general=cb_position_radio
   bottom_general=bottom
   top_general=top

   ; new ranges interactively
   print
   print,' ZOOM SPECIFICATION RANGES INPUT'
   print
   stat_new_time_range:
   print, ' INFO : total time range: ['+$
          time1+'-'+time2+']'
   tmp=0
   hh1=0 & mm1=0 & ss1=0
   hh2=0 & mm2=0 & ss2=0
   read,hh1,mm1,ss1,prompt=' INPUT: time_START [HH,MM,SS] = '
   read,hh2,mm2,ss2,prompt=' INPUT: time_END   [HH,MM,SS] = '
   t1_fod=(float(hh1)+float(mm1)/60.+float(ss1)/3600.)/24.d
   t2_fod=(float(hh2)+float(mm2)/60.+float(ss2)/3600.)/24.d
   ;print,t1_fod,t1_fod_save
   ;print,t2_fod,t2_fod_save   
   if t1_fod lt t1_fod_save or t2_fod gt t2_fod_save then goto,stat_new_time_range
   print
   stat_new_f_range:
   print, ' INFO : total frequency range: ['+$
          strtrim(f1_save,2)+'-'+strtrim(f2_save,2)+']'
   f1=0. & f2=0.
   read,f1,f2,prompt=' INPUT: frequency rage (f1<f2) [MHz,MHz] = '
;   print,f1,f1_save
;   print,f2,f2_save
   if f1 lt f1_save or f2 gt f2_save then goto,stat_new_f_range
   print
   stat_smoo_nonsmo:
   print, ' INFO : smoothing the original data or keeping the original data'
   key_sns='z'
   read,key_sns,prompt=' INPUT: smooth data [s] or keep original data [k] = '
   if key_sns ne 's' and key_sns ne 'k' then goto,stat_smoo_nonsmo

;  ; the nearest points inside the general T interval
   ind_t_bot=where(time_hh_save/24.d ge t1_fod) & ind_t_1_bot=min(ind_t_bot)
   ind_t_upp=where(time_hh_save/24.d le t2_fod) & ind_t_2_upp=max(ind_t_upp)
   data=data_general_save(ind_t_1_bot:ind_t_2_upp,*)
   data=[data,data(n_elements(data(*,0))-1,*)]
   if n_elements(data(*,0)) mod 2 eq 0 then data=[data,data(n_elements(data(*,0))-1,*)]
   ind_f=where(frequencies ge f1 and frequencies le f2)
   data=data(*,ind_f)
   data_zoom_save=data
   bottom=min(data) & top=max(data)
   bottom_zoom_save=bottom & top_zoom_save=top
   time_ss=findgen(n_elements(data(*,0)))*dt
   time_hh=hh1+mm1/60.d + ss1/3600.d + time_ss/3600.d
   t1=t1_fod*24.d & t2=t2_fod*24.d
   hh1_str=strtrim(hh1,2) & if hh1 lt 10 then hh1_str='0'+hh1_str
   mm1_str=strtrim(mm1,2) & if mm1 lt 10 then mm1_str='0'+mm1_str
   ss1_str=strtrim(ss1,2) & if ss1 lt 10 then ss1_str='0'+ss1_str
   hh2_str=strtrim(hh2,2) & if hh2 lt 10 then hh2_str='0'+hh2_str
   mm2_str=strtrim(mm2,2) & if mm2 lt 10 then mm2_str='0'+mm2_str
   ss2_str=strtrim(ss2,2) & if ss2 lt 10 then ss2_str='0'+ss2_str   
   time1=hh1_str+':'+mm1_str+':'+ss1_str
   time2=hh2_str+':'+mm2_str+':'+ss2_str    
   ; f
   frequencies=frequencies(ind_f)   
   f1=frequencies(0) & f2=frequencies(n_elements(frequencies)-1)
   goto, stat_zoom
endif

stat_zoom:
; plot parameters
print
print,' PLOTTING ZOOM PLOT...'
key_plot=0
set_plot,'x'

; default display parameters
window_width=1100
aspect_ratio=0.45
wset=2
data_title=date+' '+station
myxminor=10
mycharsize=2.5
plot_POSITION=[0.12,0.18,0.85,0.95]
myxticklen=-0.03
myyticklen=-0.01
myxticks=round(max(time_ss))            
if myxticks gt 6 then begin
   for k=2,1000-1 do begin
      myxticks=round(max(time_ss)/float(k))
      if myxticks le 6 then goto,stat_good_my
   endfor
   stat_good_my:
endif

DIVISIONS=10
mycharsize_radio=2.5
colorbar_radio_format='(i4)'
cb_position_radio=[0.87,0.18,0.90,0.95]

; plot parameters 
lut_radio=5
loadct,lut_radio,/silent,file='colors1.tbl'

;; font_adjustment_via_tmp_file_output_to_eps
;font_adjustment_via_tmp_file_output_to_eps

; general plot
stat_zoom_plot:
if key_plot ne 4 then window,1,xs=window_width,ys=window_width*aspect_ratio,$
                      xp=monitor_size(0)-window_width,yp=0,$
                      title='ZOOM PLOT'
; actions
; 1 - data range
data=(data>bottom)<top
; 2 - window aspect ratio
if key_plot ne 4 then window,1,xs=window_width,ys=window_width*aspect_ratio,$
                      xp=monitor_size(0)-window_width,yp=0,$
                      title='ZOOM PLOT'
; real plot
hm_line_time_2d_plot_equidistant, wset, data_title, $
   time_ss, frequencies, data, date,$
   time_hh/24.,$
   [max(frequencies),min(frequencies)],lut_radio,$
   xminor=myxminor,$
   charsize=mycharsize,charthick=2.0,position=plot_POSITION,$
   xticklen=myxticklen,yticklen=myyticklen,xticks=myxticks,$
   colorbar_radio_format=colorbar_radio_format,key_smoo_nonsmo=key_sns;, font=-1

; colorbar
loadct,lut_radio,/silent,file='colors1.tbl'
displayColors=!D.N_COLORS
min_display=min(data) & max_display=max(data)
im=bytscl(data,min=min_display,max=max_display,top=displayColors-1)

COLORBAR_JR, CHARSIZE=mycharsize_radio, COLOR=color_bar_axes_ticks,charthick=2.0,$
             DIVISIONS=divisions,$
             FORMAT=colorbar_radio_format, $
             POSITION=cb_position_radio,$
             MAXRANGE=0,MINRANGE=255,$
             NCOLORS=256, $   
             TITLE='RADIO FLUX [a.u.]',$
             /VERTICAL, MINOR=minor,$
             RANGE=[min(data),max(data)],$
             ;, FONT=font, TICKLEN=ticklen, _EXTRA=extra,
             key_lut_reverse=0,  KEY_ALOG=0, /RIGHT;, font=-1

if key_plot eq 4 then begin
   mycharsize=mycharsize*3.
   mycharsize_radio=mycharsize_radio*3.
endif
if key_plot eq 4 then eps_to_jpeg, path_plots,pathfilename_out_core
if key_plot eq 4 then eps_output_end, key_plot,path_plots,pathfilename_out_core

; menu after zool plot
stat_menu_zoom:
key=0
print
print,' INPUT: 0 - end'
print,'        1 - data range adjustment'
print,'        2 - LUT number'
print,'        3 - window aspect ratio change'
print,'        4 - x-ticks number'
print,'        5 - x-minorticks number'
print,'        6 - bar-ticks number'
print,'        7 - EPS + JPEG output files'
print,'        8 - saving zoomed data to SAV file'
print,'       11 - back to general plot'
read,key,prompt='        key =  '
if key eq 0 then goto,stat_end
if key lt 0 or key gt 11 then goto,stat_menu_general
if key eq 1 then begin
   print
   print, ' INFO : total  data range: ['+strtrim(bottom_zoom_save)+','+$
                                         strtrim(top_zoom_save)+']'
   print, ' INFO : actual data range: ['+strtrim(bottom)+','+$
                                         strtrim(top)+']'
   read,bottom,top,prompt=' INPUT: data range - bottom,top = '
   ;data=data_general_save
   ;data=data_zoom_save
   goto, stat_zoom_plot
endif
if key eq 2 then begin
   print
   print, ' INFO : current LUT number: '+strtrim(lut_radio)
   ;xloadct
   read,lut_radio,prompt=' INPUT: new LUT number = '
   goto, stat_zoom_plot
endif
if key eq 3 then begin
   print
   print, ' INFO : current window aspect ratio: '+strtrim(aspect_ratio)
   read,aspect_ratio,prompt=' INPUT: aspect_ratio = '
   goto, stat_zoom_plot
endif
if key eq 4 then begin
   print
   print, ' INFO : actual xtics number: '+strtrim(myxticks)
   read,myxticks,prompt=' INPUT: new xtics number = '
   goto, stat_zoom_plot
endif
if key eq 5 then begin
   print
   print, ' INFO : actual xminortics number: '+strtrim(myxminor)
   read,myxminor,prompt=' INPUT: new xminortics number = '
   goto, stat_zoom_plot
endif
if key eq 6 then begin
   print
   print, ' INFO : actual bar-ticks number: '+strtrim(divisions)
   read,divisions,prompt=' INPUT: new  bar-ticks number = '
   goto, stat_zoom_plot
endif
if key eq 7 then begin
   path_plots=strmid(path_data,0,strpos(path_data,'/',/reverse_search)-1)
   path_plots=strmid(path_plots,0,strpos(path_plots,'/',/reverse_search))+'/'
   path_plots=path_plots+'plots/'
   file_mkdir,path_plots
   key_plot=4
   ; font_adjustment_via_tmp_file_output_to_eps
   font_adjustment_via_tmp_file_output_to_eps
   key_plot=4                   ; eps 
   eps_output_start, key_plot,window_width,aspect_ratio,$
                     path_plots,pathfilename_out_core,$
                     date,time1,time2,f1,f2,lut_radio,station
   mycharsize=mycharsize/3.
   mycharsize_radio=mycharsize_radio/3.
   goto, stat_zoom_plot
endif
if key eq 8 then begin
   ; path + subdir creation
   path_outts=strmid(path_data,0,strpos(path_data,'/',/reverse_search)-1)
   path_outts=strmid(path_outts,0,strpos(path_outts,'/',/reverse_search))+'/'
   path_outts=path_outts+'zoom_data_SAV_files/'
   file_mkdir,path_outts
   ; filename creation
   pathfilename_out_start=date+'_'+time1+'-'+time2+'_'+$
                          strtrim(round(f1),2)+'-'+strtrim(round(f2),2)+'_'+station+'_'+$
                          'lut_'+strtrim(lut_radio,2)
   print,' INFO : output SAV filename beginning = '+pathfilename_out_start
   pathfilename_out_add=''
   read,pathfilename_out_add,prompt=' INPUT: output SAV filename addition = '
   if pathfilename_out_add ne '' then begin
      under_tmp='_'
   endif else begin
      under_tmp=''
   endelse   
   pathfilename_out_core=pathfilename_out_start+under_tmp+pathfilename_out_add
   ; saving the zoomed data to a SAV file
   save,filename=path_outts+pathfilename_out_core+'.sav',n_fts_files, $
                                          data,time_ss,time_hh,frequencies, $
                                          t1,t2,nt,dt,f1,f2,df,nf,$
                                          date,time1,time2,t1_fod,t2_fod,n_min,$
                                          hh1,mm1,ss1,hh2,mm2,ss2,$
                                          station
   goto, stat_zoom_plot
endif
if key eq 11 then begin
if key_data_source eq 1 then begin
   goto, stat_read_fts_general_plot
endif
if key_data_source eq 2 then begin
   goto, stat_read_fit_general_plot
endif
if key_data_source eq 3 then begin
   goto, stat_read_sav_general_plot
endif
endif

stat_end:
print
print,' END...'
print
end
