PRO orf_gestion_trou,sp,tab_ms,nb_spec,nI,delta_t,$
                     ind0,count_trou,$
                     sp_out,tab_ms_out
;+
; But:    Cette fonction est appelee lorsque l on a des trous en temps. 
;         Elle retourne un spectre sans trou en temps, les intervalles etant
;         remplis par des NaN
;
; Input : 
;         sp         : spectre a corriger
;         tab_ms     : tableau du temps en ms
;         nb_spec    : nombre de points en temps
;         nI         : nombre de frequences
;         delta_t    : pas en temps en sec
;         ind0       : tableau contenant les indices des trous en temps
;         count_trou : nombre de trous
; Ouput :
;         sp_out     : spectre corrige
;         tab_ms_out : tableau du temps corrige
;
; Eleonore : 27/06/2012
;
; Modif 2012/07/02  : recherche du fichier de frequence le plus recent
;                      quand le fichier attendu n'existe pas 
;                     (dans le cas d un demarrage chaotique des
;                     observations)
;
; Modif 2012/10/10  : gestion des multifichiers finalisee
;-
  tab_ms0 = tab_ms                             
  nb_pts_trou = intarr(n_elements(ind0))
  ind = ind0

  print,"Attention il y a ",count_trou," trou(s) en temps."
  deltat_trou = lonarr(count_trou)
  for i=0,count_trou-1 do begin
     print,"Trou de ",msh(tab_ms0(ind0[i]-1))," à ",msh(tab_ms0(ind0[i]))
     deltat_trou[i] = tab_ms0(ind[i]) - tab_ms0(ind[i]-1)
     nb_pts_trou[i] = long(deltat_trou[i]/float(delta_t))
  endfor

  nb_pts_trou_tot = long(total(nb_pts_trou))
  sp_out = fltarr(nI,nb_spec + nb_pts_trou_tot)
  ind = ind0

  for i=0,n_elements(ind0)-1 do begin
     tab_ms_trou = lindgen(nb_pts_trou[i])*long(delta_t)+replicate(tab_ms0(ind[i]-1),nb_pts_trou[i])
;    restauration du tableau du temps
     tab_ms_out = [tab_ms0(0:ind[i]-1),tab_ms_trou,tab_ms0(ind[i]:*)]
;    plot,tab_ms_out-tab_ms_out(0)   
     tab_ms0 = tab_ms_out
     if i eq 0 then begin
        part1 = sp[*,0:ind0[i]-1]
        part2 = fltarr(nI,nb_pts_trou[i]) + !Values.F_nan
        part3 = sp[*,ind0[i]:*]
        sp_out[*,0:ind0[i]-1] = part1
        sp_out[*,ind0[i]:ind0[i]+nb_pts_trou[i]-1] = part2
        sp_out[*,ind0[i]+nb_pts_trou[i]:ind0[i]+nb_pts_trou[i]+n_elements(part3[0,*])-1] = part3
     endif else begin
        part1 = sp_out[*,0:ind[i]-1]
        part2 = fltarr(nI,nb_pts_trou[i]) + !Values.F_nan
        part3 = sp[*,ind0[i]:*]
        sp_out[*,0:ind[i]-1] = part1
        sp_out[*,ind[i]:ind[i]+nb_pts_trou[i]-1] = part2
        sp_out[*,ind[i]+nb_pts_trou[i]:ind[i]+nb_pts_trou[i]+n_elements(part3[0,*])-1] = part3
     endelse
     ind = ind + nb_pts_trou[i]
  endfor  
END

FUNCTION raworfees, f,stokes, integ=integ, test=test, time_range = time_range

;+ ***********************************************************************
; NAME:
;	raworfees
;
; PURPOSE:
;       la fonction retourne une structure contenant le spectre dynamique demande,
;       le tableau du temps et le tableau des frequences associes
;       IDL> help,st,/str
;       ** Structure <167dae8>, 7 tags, length=146888152, data length=146888150, refs=1:
;       IMAGE           FLOAT     Array[36001, 1014]
;       FREQ            FLOAT     Array[1014]
;       JD              DOUBLE    Array[36001]
;       ANYTIM          DOUBLE    Array[36001]
;       TEMPS           DOUBLE    Array[36001] (sec)
;       DATE            INT       Array[3]
;       DELTA_T         DOUBLE          0.10000000 (sec)
;
;       On peut selectionner un intervalle de temps (pour les fichiers
;       haute resolution)
;
;
; CATEGORY:
;	radio-monitoring
;
; CALLING SEQUENCE:
;       st = raworfees('/data/nrhmeudon/rawdata/orfees/orf20120704_095926.fts','i')
; 	st = raworfees('/data/nrhmeudon/rawdata/orfees/orf20120704_095926.fts','i',time_range=['10:00','11:00'])    
;
; INPUTS:
;       f : fichier d entree
;       '/data/nrhmeudon/rawdata/orfees/orf20120704_095926.fts'
;       stokes: 'i'pour intensite ou 'v' pour polar
;
; KEYWORDS:
;       time_range = ['10:00','11:00'] (par defaut tout le fichier est traite)
;
; MODIFICATION HISTORY:
;	Ecrit par: Eleonore le 26/07/2012 
;       Modification juillet 2012 : ajout du mot-clé time_range pour ne lire
;             qu une partie des donnees (fichier du jour de 5 Go) 
;
;       Modification septembre 2012 : ajout de la gestion des trous 
;             dans le cas de fichiers multiples
;
;       Modification octobre 2012   : suite au passage des intensites
;             en lineaire ( 05/09/2012 ) passage des intensites en log
;             dans la structure de sortie 
;
;       Modification fevrier 2013  : renvoi d une structure vide et
;       non d une chaine vide si pas de donnees dans le time-range
;       demande
;
;       Modification mars 2013 : cas de n_bands = 1 (fichier test) 
;
;-*******************************************************************
; Toutes les 20ms on change de bande, les 5 bandes sont balayees en
; 0,1s .Toutes les 0,1s les 5 bandes sont balayees, sans interruption.
 
 orfeesV = {image:fltarr(2),freq:fltarr(2),jd:dblarr(2),anytim:dblarr(2),temps:dblarr(2),date:[0,0,0],delta_t:0.}
 orfeesI = {image:fltarr(2),freq:fltarr(2),jd:dblarr(2),anytim:dblarr(2),temps:dblarr(2),date:[0,0,0],delta_t:0.}

; Recherche tous les fichiers de la journee
  liste_fich = file_search(f,count=count)
  if count eq 0 then begin
     print,'aucun fichier trouve'
     return,''
  endif

; Lecture de la date
  pos=strpos(liste_fich[0],'.fts')
  struct0=mrdfits(liste_fich[0],0,h0)
  ch_date = fxpar(h0,'DATE-OBS')
; ch_date commence par 2 caracteres blancs
  yy = strmid(ch_date,2,2)
  if yy le '50' then yyyy = '20'+yy else yyyy = '19'+yy
  yyyy = fix(yyyy)
  mm = fix(strmid(ch_date,5,2))
  dd = fix(strmid(ch_date,8,2))

; tranche de temps demandee
  if n_elements(time_range) ne 0 then begin
     hdeb_util = time_range[0]
     hfin_util = time_range[1]
     hdeb = long(strmid(hdeb_util,0,2))*3600000L + long(strmid(hdeb_util,2,2))*60000L
     hfin = long(strmid(hfin_util,0,2))*3600000L + long(strmid(hfin_util,2,2))*60000L
     print,'RawOrfees  time_range :  ', time_range
  endif

  if (n_elements(stokes) eq 0) then stokes='i'
  flag_tab_temps = 0

; boucle sur les fichiers
  for j=0,count-1 do begin
     print,'RawOrfees, j, : ',j,' ', liste_fich[j]
     struct1=mrdfits(liste_fich[j],1,h1)
;    certains fichiers tests de fin de journée n'ont qu une bande 
     if (struct1.n_bands eq 1) then continue
     struct2_b = mrdfits(liste_fich[j],2,h2,range=[0,0])
     nb_records = fxpar(h2,'NAXIS2')
     record1 = 0
     record2 = nb_records-1
;    lecture du dernier record pour avoir l heure de fin du fichier
     struct2_e = mrdfits(liste_fich[j],2,h2,range=[nb_records-1,nb_records-1])
     hdeb_fich = ((struct2_b.time_b1+struct2_b.time_b5)/2.)
     hfin_fich = ((struct2_e.time_b1+struct2_e.time_b5)/2.)
     delta_t = (struct2_e.time_b1 - struct2_b.time_b1)/(nb_records-1L)
     if n_elements(time_range) ne 0 then  begin
        record1 = round((hdeb-hdeb_fich)/delta_t)
        record2 = round((hfin-hdeb_fich)/delta_t)
        if record1 lt 0 and record2 lt 0 then continue ; continue passe au j suivant
        if record1 gt nb_records-1 and record2 gt nb_records-1 then continue
        if record1 lt 0 then record1 = 0
        if record2 gt nb_records-1 then record2 = nb_records-1
     endif
     struct2 = mrdfits(liste_fich[j],2,h2,range=[record1,record2])
     tab_freq = [struct1.freq_b1, struct1.freq_b2, struct1.freq_b3, struct1.freq_b4, struct1.freq_b5]    
; concatenation des tableaux temps et image en cas de multifichiers
     if (flag_tab_temps eq 1) then begin
        if (stokes eq 'i') then begin
           tab_tmp = [struct2.stokesi_b1,struct2.stokesi_b2,struct2.stokesi_b3,struct2.stokesi_b4,struct2.stokesi_b5]
; ATTENTION: pour concatener des tableaux il faut que la dimension sur laquelle on concatene soit en premiere position
           tab_tmp = transpose(tab_tmp)
           tab_imageI = transpose(tab_imageI)
           tab_imageI = [tab_imageI,[tab_tmp]]
           tab_imageI = transpose(tab_imageI)
        endif  else begin
           tab_tmp = [struct2.stokesv_b1,struct2.stokesv_b2,struct2.stokesv_b3,struct2.stokesv_b4,struct2.stokesv_b5]
           tab_tmp = transpose(tab_tmp)
           tab_imageV = transpose(tab_imageV)
           tab_imageV = [tab_imageV,[tab_tmp]]
           tab_imageV = transpose(tab_imageV)
        endelse
        tab_temps = [tab_temps ,[(struct2.time_b1+struct2.time_b5)/2]]
     endif else begin
        if (stokes eq 'i') then begin
           tab_imageI = [struct2.stokesi_b1,struct2.stokesi_b2,struct2.stokesi_b3,struct2.stokesi_b4,struct2.stokesi_b5]
        endif else begin
           tab_imageV = [struct2.stokesv_b1,struct2.stokesv_b2,struct2.stokesv_b3,struct2.stokesv_b4,struct2.stokesv_b5]
        endelse
        tab_temps = (struct2.time_b1+struct2.time_b5)/2
        flag_tab_temps =1
     endelse         
  endfor
  nb_temps = n_elements(tab_temps)
  nb_freq = n_elements(tab_freq)

 if nb_temps eq 0 then begin
    if (stokes eq 'i') then return, orfeesI $
    else return, orfeesV
 endif 

  help,struct1, /str
;** Structure <2486318>, 11 tags, length=4080, data length=4080, refs=1:
;   N_BANDS         LONG                 5
;   NP_B1           LONG               431
;   FREQ_B1         FLOAT     Array[431]
;   NP_B2           LONG               215
;   FREQ_B2         FLOAT     Array[215]
;   NP_B3           LONG               175
;   FREQ_B3         FLOAT     Array[175]
;   NP_B4           LONG                91
;   FREQ_B4         FLOAT     Array[91]
;   NP_B5           LONG               102
;   FREQ_B5         FLOAT     Array[102]

  help,struct2, /str
;** Structure <2448548>, 15 tags, length=8132, data length=8132, refs=1:
;   TIME_B1         LONG          39313464
;   STOKESI_B1      FLOAT     Array[431]
;   STOKESV_B1      FLOAT     Array[431]
;   TIME_B2         LONG          39313488
;   STOKESI_B2      FLOAT     Array[215]
;   STOKESV_B2      FLOAT     Array[215]
;   TIME_B3         LONG          39313512
;   STOKESI_B3      FLOAT     Array[175]
;   STOKESV_B3      FLOAT     Array[175]
;   TIME_B4         LONG          39313536
;   STOKESI_B4      FLOAT     Array[91]
;   STOKESV_B4      FLOAT     Array[91]
;   TIME_B5         LONG          39313564
;   STOKESI_B5      FLOAT     Array[102]
;   STOKESV_B5      FLOAT     Array[102]

; Recherche de trous en temps introduits par la concatenation des
; differents fichiers
  tab_temps1 = shift(tab_temps,1)
  tdif = tab_temps - tab_temps1
  delta_t = tab_temps[1]-tab_temps[0]
  ind0 =  where (tdif gt delta_t+10,count_trou)

  print,'nombre de trous :',count_trou 

  if (stokes eq 'i') then sp = tab_imageI
  if (stokes eq 'v') then sp = tab_imageV

; debut de la gestion des trous
  if count_trou ne 0 then begin
     orf_gestion_trou,sp,tab_temps,nb_temps,nb_freq,delta_t,$
                      ind0,count_trou,$
                      sp_out,tab_temps_out
     tab_temps = tab_temps_out 

     if (stokes eq 'i') then tab_imageI = sp_out
     if (stokes eq 'v') then tab_imageV = sp_out
  endif                         
; fin de la boucle de gestion des trous
  
; Creation du tableau jd (jour julian) grace au 
; tableau temps (qui est en secondes)
  tab_temps = double(tab_temps)/1000.D0
  delta_t = tab_temps[1] - tab_temps[0]
  tab_anytim = double(tab_temps) + anytim([0L,0L,0L,0L,dd,mm,yy])
  jd = julday(mm,dd,yyyy,0,0,tab_temps)

; Transposition du spectre pour avoir temps-frequences
  if (stokes eq 'i') then tab_imageI_ftps = transpose(tab_imageI)
  if (stokes eq 'v') then tab_imageV_ftps = transpose(tab_imageV)


; Creation de la structure
  if (stokes eq 'i') then begin
     orfeesI = {image:10.*alog10(tab_imageI_ftps),freq:tab_freq,jd:jd,anytim:tab_anytim,temps:tab_temps,date:[yy,mm,dd],delta_t:delta_t}

     return,orfeesI
  endif else begin
     orfeesV = {image:tab_imageV_ftps,freq:tab_freq,jd:jd,anytim:tab_anytim,temps:tab_temps,date:[yy,mm,dd],delta_t:delta_t}
     return,orfeesV
  endelse

END



