;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

PRO read_orfees_radio_fts_file,     filenames, n_fts_files, $
                                    data,time_ss,time_hh,frequencies, $
                                    t1,t2,nt,dt,f1,f2,df,nf,$
                                    date,time1,time2,t1_fod,t2_fod,n_min,$
                                    hh1,mm1,ss1,hh2,mm2,ss2,$
                                    station
  
for f=0,n_fts_files-1 do begin

   ;fits_read,filenames(f),d,h
   res=raworfees(filenames(f),'i')
   
   ;IDL> help,res
   ;** Structure <4d31af8>, 7 tags, length=2895528, data length=2895526, refs=1:
   ;IMAGE           FLOAT     Array[720, 998]
   ;FREQ            FLOAT     Array[998]
   ;JD              DOUBLE    Array[720]
   ;ANYTIM          DOUBLE    Array[720]
   ;TEMPS           DOUBLE    Array[720]
   ;DATE            INT       Array[3]
   ;DELTA_T         DOUBLE          0.99600000
   
   if f eq 0 then begin
      ;date=sxpar(h,'DATE') ; DD.MM.YY
      ;date=strmid(date,6,4)+strmid(date,3,2)+strmid(date,0,2)  ;YYYYMMDD      
      ; res.date ' YY MM DD
      yytmp=strtrim(res.date(0),2) & yy=yytmp
      if res.date(0) le 10 then yy='0'+yy
      yy='20'+yy
      mmtmp=strtrim(res.date(1),2) & mm=mmtmp
      if res.date(1) le 10 then mm='0'+mm
      ddtmp=strtrim(res.date(2),2) & dd=ddtmp
      if res.date(2) le 10 then dd='0'+dd      
      date=yy+mm+dd   ;YYYYMMDD 
      ;nt_one=sxpar(h,'XMAX')-sxpar(h,'XMIN')+1
      nt_one=n_elements(res.image(*,0))
      nt=nt_one*(n_fts_files)
      ;nf=sxpar(h,'YMAX')-sxpar(h,'YMIN')+1
      nf=n_elements(res.image(0,*))
      ;data=intarr(nt,nf)
      data=fltarr(nt,nf)
   endif
   if f eq 0 then begin      
      ;data(nt_one*f:nt_one*(f+1)-1,*)=rebin($
      ;                 d(sxpar(h,'XMIN'):sxpar(h,'XMAX'),$
      ;                 sxpar(h,'YMIN'):sxpar(h,'YMAX')),$
      ;                 nt_one/1.,sxpar(h,'YMAX')-sxpar(h,'YMIN')+1)
      shift_x0=0
      data(nt_one*f:nt_one*(f+1)-1,*)=res.image
      ;tmp1=sxpar(h,'TIME1')
      ;time1=tmp1
      tmp_fod=res.temps(0)/3600./24. ; SS.SS -> HH.HH -> FOD
      fod_hhmmss, tmp_fod,hh,mm,ss
      hh1=strtrim(hh,2) & if hh lt 10 then hh1='0'+hh1
      mm1=strtrim(mm,2) & if mm lt 10 then mm1='0'+mm1
      ss1=strtrim(ss,2) & if ss lt 10 then ss1='0'+ss1
      time1=hh1+':'+mm1+':'+ss1
      t1=hhmmss_fod(hh1,mm1,ss1)*24. ; [HH.HH]
      ;tmp1=sxpar(h,'RATE') & tmp2=sxpar(h,'INTEG')
      ;dt=float(1./tmp1)*float(tmp2) ;[ps]
      dt=1.;float(res.delta_t)
   endif else begin
      ;data(nt_one*(f)+shift_x0:nt_one*(f+1)+shift_x0-1,*)=$
      ;    d(sxpar(h,'XMIN'):sxpar(h,'XMAX'),sxpar(h,'YMIN'):sxpar(h,'YMAX'))
      data(nt_one*(f)+shift_x0:nt_one*(f+1)+shift_x0-1,*)=res.image
   endelse
      if f ne 0 then data(nt_one*(f+1-1)+shift_x0-1,*)=data(nt_one*(f+1-1)+shift_x0-1-1,*)
      
endfor

;tmp2=sxpar(h,'TIME2')
;time2=tmp2
tmp_fod=res.temps(n_elements(res.temps)-1)/3600./24. ; SS.SS -> HH.HH-> FOD
fod_hhmmss, tmp_fod,hh,mm,ss
hh2=strtrim(hh,2) & if hh lt 10 then hh2='0'+hh2
mm2=strtrim(mm,2) & if mm lt 10 then mm2='0'+mm2
ss2=strtrim(ss,2) & if ss lt 10 then ss2='0'+ss2
time2=hh2+':'+mm2+':'+ss2

; final parameters
nt=n_elements(data(*,0))
t1_fod=fltarr(1) & t2_fod=fltarr(1)
t1_fod(0)=(float(hh1)+float(mm1)/60.+float(ss1)/3600.)/24.
time_ss=findgen(nt)*dt ; [s]
; corr - an estension for good time axis
t2_fod(0)=(float(hh2)+float(mm2)/60.+float(ss2)/3600.+3.*dt/3600.)/24. 
t2=(hhmmss_fod(hh2,mm2,ss2)+3.*dt/3600./24.)*24. ; [HH.HH]
time_ss(nt-1)=time_ss(nt-1)+3.*dt ; SS.SS
; final parameters
time_hh=time_ss/3600.+t1 ; UT      

; number of minutes
n_min=round((t2_fod-t1_fod)*60.)

; linearizing frequencies [MHz] and reverting slope MAX f2,...,f1 min
frequencies=fltarr(nf) 
df=(res.freq(n_elements(res.freq)-1)-res.freq(0))/float(nf+1) ; [MHz]
for f=0,nf-1 do frequencies(f)=res.freq(n_elements(res.freq)-1)-df*float(f)
;f2=sxpar(h,'FMAX') & f1=sxpar(h,'FMIN')
f2=max(frequencies) & f1=min(frequencies)
nf=(f2-f1)/float(df)+1 
for f=0,nf-1 do begin
   frequencies(f)=f2-f*df
endfor
freq_noneq=rotate(res.freq,2)

; reverting data to MAX f2,...,f1 min
data_noneq=rotate(res.image,7)

; linearizing data [MHz]
data_eq=fltarr(nt,nf)

; CALLING SEQUENCE: INTEP_GH_JR, xp,p,x,f,n,ier
; USAGE : for random values of XP :
;             intep_gh_jr, xp,p,x,f,n,ier
; INPUTS: XP - the chosen argument value
;         P  - the resultant interpolated value
;         X  - the vector of independent values
;         F  - the vector of function or dependent values
;         N  - the number of points in the (X,P) vectors
;         IER- the resultant error parameter
for t=0,nt-1 do begin
   p,t
   for f=0,nf-1 do begin
     ;intep_gh_jr, xp,            p,x,         f,                 n,ier
      intep_gh_jr, frequencies(f),p,freq_noneq,reform(data_noneq(t,*)),nf,ier
      data_eq(t,f)=p
   endfor
endfor
data=data_eq

station='ORFEES'

return
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; ORFEES

; .r orfees_fits_to_XDR_and_corrections.pro

fts_file_list='~/comp/karlicky/20170906_flare/orfees/data/ORF20170906_115500_1.fts'
n_fts_files=1

read_orfees_radio_fts_file,  fts_file_list, n_fts_files, $
                                data,time_ss,time_hh,frequencies, $
                                t1,t2,nt,dt,f1,f2,df,nf,$
                                date,time1,time2,t1_fod,t2_fod,n_min,$
                                hh1,mm1,ss1,hh2,mm2,ss2,$
                                station

help,fts_file_list, n_fts_files, $
                                data,time_ss,time_hh,frequencies, $
                                t1,t2,nt,dt,f1,f2,df,nf,$
                                date,time1,time2,t1_fod,t2_fod,n_min,$
                                hh1,mm1,ss1,hh2,mm2,ss2,station

stop

save,filename='ORF20170906_115500_1.sav',$
                                data,time_ss,time_hh,frequencies, $
                                t1,t2,nt,dt,f1,f2,df,nf,$
                                date,time1,time2,t1_fod,t2_fod,n_min,$
                                hh1,mm1,ss1,hh2,mm2,ss2,station

end

