
PRO window_plot_save_start_jr, key_plot, window_index=window_index, window_title=window_title, $
                               window_size=window_size, pathfilename_out=pathfilename_out

; .comp window_plot_save_start_jr.pro

; INPUT: key_plot = 0 - only X window
;                   1 - X window        + PNG graphical format file
;                   2 - RAM@console     + PNG graphical format file (window command /PIXMAP keyword
;                   3 - Z-buffer@server + PNG graphical format file
;                   4 - EPS graphical format file only
;
;        window_index - window index (for key_plot 0,1,2)
;        window_title -
;        window_size  - [Xsize,Y,size]
;        pathfilename_out - path + filename of the output grahical
;                           format file (without extension) - needed here only for EPS 
  
; input variable check
if key_plot lt 0 or key_plot gt 4 then begin
   print
   print,' WINDOW_PLOT_SAVE_START_JR procedure: wrong value of the KEY_PLOT input variable'
   print
   return
endif

pathfilename_out_save=pathfilename_out

if keyword_set(window_index) eq 0 then window_index=0
if keyword_set(window_title) eq 0 then window_title='IDL WINDOW '+strtrim(string(window_index),2)
if keyword_set(window_size)  eq 0 then window_size=[800,500]
if keyword_set(pathfilename_out) eq 0 then pathfilename_out='idl_window_plot_output_'+SYSTIME(/UTC) ; only for ESP output case

; graphics parameters
!p.font = -1 ; font
!p.background = 255b ; BKG set to white (for some LUTs)
!p.color = 0b        ; axes, marks, titles set to black (for some LUTs)

; X only or X + PNG or X + PNG through RAM@console
if key_plot eq 0 or key_plot eq 1 or key_plot eq 2 then begin
   pixmap= (key_plot-1) > 0
   window,window_index,title=window_title,xs=window_size(0),ys=window_size(0),pixmap=pixmap
endif

; Z-buffer@server + PNG graphical format file
if key_plot eq 3 then begin   
   device_2_z,size_window=window_size
endif

; EPS graphical format file only
if key_plot eq 4 then begin
   eps_output_aspect_ratio=float(window_size(1))/float(window_size(0))
   device_2_eps,pathfilename_out,aspect_ratio=eps_output_aspect_ratio
endif

pathfilename_out=pathfilename_out_save

return
end
