;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; ORFEES

; .r orfees_fits_to_XDR_and_corrections.pro

print
print,' ORFEES_FITS_TO_XDR_AND_CORRECTIONS'
print

; EDIT
path0=''

fts_file_list=dialog_pickfile(path=path0,/READ,TITLE='SELECT ORFEES FITS FILE')
n_fts_files=1
print
print,' INFO  : input ORFEES FITS file name = ',fts_file_list

print
print,' INFO  : reading, correcting ORFEES data...'
print

; FITS file reading and coreections 
read_orfees_radio_fts_file, fts_file_list, n_fts_files, $
                            data,time_ss,time_hh,frequencies, $
                            t1,t2,nt,dt,f1,f2,df,nf,$
                            date,time1,time2,t1_fod,t2_fod,n_min,$
                            hh1,mm1,ss1,hh2,mm2,ss2,$
                            station

;help,fts_file_list, n_fts_files, $
;                    data,time_ss,time_hh,frequencies, $
;                    t1,t2,nt,dt,f1,f2,df,nf,$
;                    date,time1,time2,t1_fod,t2_fod,n_min,$
;                    hh1,mm1,ss1,hh2,mm2,ss2,station
;stop

print,' AVAILABLE VARIABLES = '
print
print,' DATA        - 2D (time,frequency) radio intesities'
print,' TIME_SS     - temporal axis [seconds]'
print,' TIME_HH     - tmeporal axis UTC [HH.HH]'
print,' FREQUENCIES - frequency axis [MHz]'
print,' T1,T2       - temporal axis - first value [HH.HH], last value[HH.HH]'
print,' NT,DT       - temporal axis - number of values, temporal step [s]'
print,' F1,F2       - frequency axis- first and last values [MHz], f1<f2 '
print,' DF,NF       - frequency axis- number of values, freq. step [MHz]'
print,' DATE        - DATE [YYYYMMDD]'
print,' TIME1       - time start - string [HH:MM:SS]' 
print,' TIME2       - time end   - string [HH:MM:SS]'
print,' T1_FOD      - time start - fraction of day - float'
print,' T2_FOD      - time start - fraction of day - float'
print,' N_MIN       - time interval - number of minutes - integer'
print,' HH1,MM1,SS1 - time start - hour, minute, second - strings'
print,' HH2,MM2,SS2 - time end   - hour, minute, second - strings'
print,' STATION     - string = ORFEES'

; output XDR filename
fts_file_list_out=strmid(fts_file_list,0,strpos(fts_file_list,'.',/reverse_search))+'.xdr'

print
print,' INFO  : saving the corrected ORFEES data...'
print
print,'         filename = '+fts_file_list_out
save,filename=fts_file_list_out,$     
                                data,time_ss,time_hh,frequencies, $
                                t1,t2,nt,dt,f1,f2,df,nf,$
                                date,time1,time2,t1_fod,t2_fod,n_min,$
                                hh1,mm1,ss1,hh2,mm2,ss2,station

print
print,' ORFEES_FITS_TO_XDR_AND_CORRECTIONS finished'
print

end

